/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.speech;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sayTheSpire.Output;
import sayTheSpire.speech.TolkHandler;

public class TolkResourceHandler
extends TolkHandler {
    private static Logger logger = LogManager.getLogger((String)TolkResourceHandler.class.getName());

    public TolkResourceHandler() {
        this.setName("tolk_resources");
    }

    @Override
    public void disposeResources() {
        String[] resources = TolkResourceHandler.getResources();
        try {
            for (String resource : resources) {
                File file = new File(System.getProperty("user.dir") + "/" + resource);
                file.delete();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        logger.info("All files cleared.");
    }

    @Override
    public Boolean loadResources() {
        try {
            String[] resources;
            String path = TolkResourceHandler.getPath();
            for (String resource : resources = TolkResourceHandler.getResources()) {
                int len;
                InputStream stream = this.getClass().getResourceAsStream(path + resource);
                if (stream == null) {
                    System.err.println("input stream for " + path + resource + " is null.");
                }
                FileOutputStream outStream = new FileOutputStream(System.getProperty("user.dir") + "/" + resource);
                byte[] buffer = new byte[8192];
                while ((len = stream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                stream.close();
                outStream.close();
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            e.printStackTrace();
            return false;
        }
        logger.info("All files written");
        return true;
    }

    @Override
    public void unload() {
        super.unload();
        try {
            if (Output.config.getBoolean("resources.unload_native_libs").booleanValue()) {
                logger.info("attempting to unload native libs");
                this.unloadNativeLibs();
                logger.info("Native libs successfully unloaded.");
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            t.printStackTrace();
        }
        logger.info("Tolk successfully unloaded.");
    }

    public static String getPath() {
        String path = "/tolk/";
        path = TolkResourceHandler.is64Bit() == false ? path + "x86" : path + "x64";
        path = path + "/";
        return path;
    }

    public static String[] getResources() {
        if (!TolkResourceHandler.is64Bit().booleanValue()) {
            return new String[]{"Tolk.dll", "nvdaControllerClient32.dll", "SAAPI32.dll", "Tolk.exp", "Tolk.lib"};
        }
        return new String[]{"Tolk.dll", "nvdaControllerClient64.dll", "SAAPI64.dll", "Tolk.exp", "Tolk.lib"};
    }

    public static Boolean is64Bit() {
        if (System.getProperty("os.name").contains("Windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty("os.arch").indexOf("64") != -1;
    }

    public void unloadNativeLibs() throws Throwable {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
        field.setAccessible(true);
        Vector libs = (Vector)field.get(classLoader);
        for (Object o : libs) {
            Method finalize = o.getClass().getDeclaredMethod("finalize", new Class[0]);
            finalize.setAccessible(true);
            finalize.invoke(o, new Object[0]);
        }
    }
}

