/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.speech;

import sayTheSpire.speech.SpeechHandler;
import speechd.ssip.SSIPClient;
import speechd.ssip.SSIPException;
import speechd.ssip.SSIPPriority;

public class SpeechdHandler
extends SpeechHandler {
    SSIPClient spd = null;

    public SpeechdHandler() {
        this.setName("speech-dispatcher");
    }

    @Override
    public Boolean detect() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    @Override
    public void disposeResources() {
    }

    @Override
    public Boolean loadResources() {
        return true;
    }

    @Override
    public Boolean load() {
        try {
            this.spd = new SSIPClient("sayTheSpire", null, null);
        }
        catch (SSIPException e) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean output(String text, Boolean interrupt) {
        try {
            if (interrupt.booleanValue()) {
                this.spd.say(SSIPPriority.IMPORTANT, text);
            } else {
                this.spd.say(SSIPPriority.MESSAGE, text);
            }
        }
        catch (SSIPException e) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean silence() {
        try {
            this.spd.stop();
        }
        catch (SSIPException e) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean speak(String text, Boolean interrupt) {
        try {
            if (interrupt.booleanValue()) {
                this.spd.say(SSIPPriority.IMPORTANT, text);
            } else {
                this.spd.say(SSIPPriority.MESSAGE, text);
            }
        }
        catch (SSIPException e) {
            return false;
        }
        return true;
    }

    @Override
    public void unload() {
        try {
            this.spd.close();
        }
        catch (SSIPException e) {
            this.spd = null;
            return;
        }
        this.spd = null;
    }
}

