/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.speech;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sayTheSpire.Output;
import sayTheSpire.speech.ClipboardHandler;
import sayTheSpire.speech.SpeechHandler;
import sayTheSpire.speech.SpeechdHandler;
import sayTheSpire.speech.TolkHandler;
import sayTheSpire.speech.TolkResourceHandler;

public class SpeechManager {
    private static Logger logger = LogManager.getLogger((String)Output.class.getName());
    private ArrayList<SpeechHandler> handlers = new ArrayList();
    private SpeechHandler currentHandler = null;

    public SpeechManager() {
        this.addHandlers();
    }

    private void addHandlers() {
        this.registerHandler(new TolkResourceHandler());
        this.registerHandler(new TolkHandler());
        this.registerHandler(new SpeechdHandler());
        this.registerHandler(new ClipboardHandler());
    }

    public void disposeResources() {
        if (this.currentHandler == null) {
            return;
        }
        this.currentHandler.disposeResources();
    }

    public Boolean output(String text, Boolean interrupt) {
        if (this.currentHandler == null) {
            return false;
        }
        return this.currentHandler.output(text, interrupt);
    }

    public Boolean registerHandler(SpeechHandler handler) {
        if (this.handlers.contains(handler)) {
            return false;
        }
        this.handlers.add(handler);
        logger.info("Registered speech handler " + handler.getName());
        return true;
    }

    private void reorderHandlerList() {
        ArrayList preferedOrder = (ArrayList)Output.config.getList("advanced.prefered_speech_handler_order", null);
        if (preferedOrder == null || preferedOrder.size() == 0) {
            return;
        }
        HashMap<String, SpeechHandler> reorderedHandlers = new HashMap<String, SpeechHandler>();
        ListIterator<SpeechHandler> iter = this.handlers.listIterator();
        while (iter.hasNext()) {
            SpeechHandler handler = iter.next();
            if (!preferedOrder.contains(handler.getName())) continue;
            iter.remove();
            reorderedHandlers.put(handler.getName(), handler);
        }
        iter = preferedOrder.listIterator(preferedOrder.size());
        while (iter.hasPrevious()) {
            String name = (String)((Object)iter.previous());
            this.handlers.add(0, (SpeechHandler)reorderedHandlers.get(name));
        }
    }

    public Boolean setup() {
        logger.info("Setting up speech handlers.");
        this.reorderHandlerList();
        for (SpeechHandler handler : this.handlers) {
            if (!handler.detect().booleanValue()) {
                logger.info("Speech handler " + handler.getName() + " detect returned false.");
                continue;
            }
            if (!handler.loadResources().booleanValue()) {
                logger.info("Speech handler " + handler.getName() + " failed to load resources");
                continue;
            }
            if (!handler.load().booleanValue()) {
                logger.info("Speech handler " + handler.getName() + " failed to load.");
                continue;
            }
            this.currentHandler = handler;
            logger.info("Speech handler " + handler.getName() + " successfully loaded.");
            return true;
        }
        return false;
    }

    public Boolean silence() {
        if (this.currentHandler == null) {
            return false;
        }
        return this.currentHandler.silence();
    }

    public Boolean unload() {
        if (this.currentHandler == null) {
            return false;
        }
        this.currentHandler.unload();
        return true;
    }

    public boolean unregisterHandler(SpeechHandler handler) {
        if (!this.handlers.contains(handler)) {
            return false;
        }
        this.handlers.remove(handler);
        return true;
    }
}

