/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.map;

import java.util.HashSet;
import sayTheSpire.map.VirtualMapNode;

public abstract class VirtualMapEdge {
    public abstract Boolean getIsForward();

    public abstract VirtualMapNode getEnd();

    public abstract VirtualMapNode getStart();

    public abstract HashSet<String> getTags();

    public String getShort(Boolean includeCoordinates) {
        VirtualMapNode node = this.getEnd();
        if (node == null) {
            return "Error on map edge, report to mod developer";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(node.getLabel());
        if (includeCoordinates.booleanValue()) {
            sb.append(", " + node.getX() + ", " + node.getY());
        }
        HashSet<String> tags = this.getTags();
        tags.addAll(node.getTags());
        if (!tags.isEmpty()) {
            sb.append(" (" + String.join((CharSequence)", ", tags) + ")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        VirtualMapEdge e = (VirtualMapEdge)o;
        return this.getStart().equals(e.getStart()) && this.getEnd().equals(e.getEnd());
    }

    public abstract VirtualMapEdge invert();
}

