/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.map;

import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.rooms.MonsterRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomElite;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.ShopRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sayTheSpire.Output;
import sayTheSpire.localization.LocalizationContext;
import sayTheSpire.map.BaseBossNode;
import sayTheSpire.map.BaseMap;
import sayTheSpire.map.BaseMapEdge;
import sayTheSpire.map.VirtualMap;
import sayTheSpire.map.VirtualMapEdge;
import sayTheSpire.map.VirtualMapNode;
import sayTheSpire.utils.MapUtils;
import sayTheSpire.utils.OutputUtils;

public class BaseRoomNode
extends VirtualMapNode {
    private MapRoomNode node = null;
    private LocalizationContext localization = Output.localization.getContext("map");

    public BaseRoomNode(MapRoomNode node) {
        this(-1, -1);
        this.node = node;
    }

    public BaseRoomNode(int x, int y) {
        super(x, y);
        this.localization.put("player", OutputUtils.getPlayerName());
    }

    @Override
    public List<VirtualMapEdge> getEdges() {
        ArrayList<VirtualMapEdge> edges = new ArrayList<VirtualMapEdge>();
        if (this.getY() >= 0 && this.node == null) {
            return edges;
        }
        VirtualMap map = this.getMap();
        int targetY = this.getY() + 1;
        if (MapUtils.isBossAvailable(this).booleanValue()) {
            BaseBossNode bossNode = new BaseBossNode(-1, targetY, MapUtils.getLocalizedBossName());
            edges.add(new BaseMapEdge(this, bossNode));
            return edges;
        }
        for (int targetX = 0; targetX <= 6; ++targetX) {
            MapRoomNode targetNode;
            BaseRoomNode target = (BaseRoomNode)map.getNodeAt(targetX, targetY);
            if (target == null || (targetNode = target.getGameNode()) != null && !targetNode.hasEdges()) continue;
            Boolean flightConnected = false;
            if (this.getGameNode().wingedIsConnectedTo(targetNode) && !this.getGameNode().isConnectedTo(targetNode) && targetY > 0) {
                flightConnected = true;
            } else if (!this.getGameNode().isConnectedTo(targetNode) && targetY != 0) continue;
            BaseMapEdge edge = new BaseMapEdge(this, target);
            if (flightConnected.booleanValue()) {
                edge.addTag(this.localization.localize("tags.requires flight"));
            }
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public Boolean getIsVisited() {
        MapRoomNode gameNode = this.getGameNode();
        if (gameNode == null) {
            return false;
        }
        return gameNode.taken;
    }

    public VirtualMap getMap() {
        return new BaseMap();
    }

    public MapRoomNode getGameNode() {
        return this.node;
    }

    @Override
    public String getName() {
        MapRoomNode node = this.getGameNode();
        if (node == null) {
            return "unknown";
        }
        if (node.room instanceof MonsterRoomElite) {
            return "elite monster";
        }
        if (node.room instanceof MonsterRoom) {
            return "monster";
        }
        if (node.room instanceof ShopRoom) {
            return "merchant";
        }
        if (node.room instanceof RestRoom) {
            return "rest";
        }
        if (node.room instanceof TreasureRoom) {
            return "treasure";
        }
        return "unknown";
    }

    @Override
    public String getLabel() {
        return this.localization.localize("names." + this.getName());
    }

    @Override
    public HashSet<String> getTags() {
        HashSet<String> nodeTags;
        HashSet<String> tags = new HashSet<String>();
        MapRoomNode node = this.getGameNode();
        if (node == null) {
            return tags;
        }
        MapRoomNode utilNode = MapUtils.getCurrentNode();
        if (utilNode != null && node == utilNode) {
            tags.add(this.localization.localize("tags.player location"));
        }
        if (node.hasEmeraldKey) {
            tags.add(this.localization.localize("tags.burning icon"));
        }
        if (Output.mapManager != null && (nodeTags = Output.mapManager.getNodeTags(node)) != null) {
            tags.addAll(nodeTags);
        }
        return tags;
    }

    @Override
    public int getX() {
        if (this.node != null) {
            return this.node.x;
        }
        return super.getX();
    }

    @Override
    public int getY() {
        if (this.node != null) {
            return this.node.y;
        }
        return super.getY();
    }

    @Override
    public Boolean hasEdges() {
        MapRoomNode node = this.getGameNode();
        if (node == null) {
            return false;
        }
        return MapUtils.isBossAvailable(this) != false || node.hasEdges();
    }
}

