/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.map;

import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.map.MapRoomNode;
import java.util.ArrayList;
import sayTheSpire.map.BaseMapEdge;
import sayTheSpire.map.BaseRoomNode;
import sayTheSpire.map.BaseStartNode;
import sayTheSpire.map.VirtualMap;
import sayTheSpire.map.VirtualMapEdge;
import sayTheSpire.map.VirtualMapNode;
import sayTheSpire.utils.MapUtils;

public class BaseMap
extends VirtualMap {
    private String id = "base." + AbstractDungeon.id;

    @Override
    public String getId() {
        return this.id;
    }

    private static ArrayList<ArrayList<MapRoomNode>> getDungeonMap() {
        return CardCrawlGame.dungeon.getMap();
    }

    @Override
    public VirtualMapNode getNodeFromObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof MapRoomNode)) {
            return null;
        }
        return new BaseRoomNode((MapRoomNode)obj);
    }

    @Override
    public VirtualMapEdge getParentEdge(VirtualMapNode node) {
        if (node == null) {
            return null;
        }
        for (int y = node.getY(); y > -1; --y) {
            for (int x = 0; x <= 6; ++x) {
                VirtualMapNode source = this.getNodeAt(x, y);
                if (source == null || (!source.getIsVisited().booleanValue() || !source.isConnectedTo(node).booleanValue()) && !(source instanceof BaseStartNode)) continue;
                return new BaseMapEdge(node, source);
            }
        }
        return null;
    }

    @Override
    public VirtualMapNode getNodeAt(int x, int y) {
        ArrayList<ArrayList<MapRoomNode>> map = BaseMap.getDungeonMap();
        if (map == null) {
            return null;
        }
        if (y == -1) {
            return new BaseStartNode();
        }
        if (y >= map.size()) {
            return null;
        }
        for (MapRoomNode node : map.get(y)) {
            if (node.x != x || node.y != y || !node.hasEdges()) continue;
            return new BaseRoomNode(node);
        }
        return null;
    }

    @Override
    public VirtualMapNode getPlayerNode() {
        MapRoomNode node = MapUtils.getCurrentNode();
        if (node == null || node.x < 0 || node.x > 6) {
            return new BaseStartNode();
        }
        return this.getNodeAt(node.x, node.y);
    }
}

