/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.events;

import com.megacrit.cardcrawl.core.AbstractCreature;
import sayTheSpire.events.Event;
import sayTheSpire.utils.OutputUtils;

public class DialogueEvent
extends Event {
    private String message;
    private String source;
    private String type;

    public DialogueEvent(String type, AbstractCreature source, String message) {
        super("dialogue");
        this.message = message;
        this.source = OutputUtils.getCreatureName(source);
        this.type = type;
        this.context.put("message", message);
        this.context.put("source", this.source);
        this.context.put("dialogueType", this.context.localize(".text.dialogueTypes." + type));
    }

    public DialogueEvent(String type, String source, String message) {
        super("dialogue");
        this.message = message;
        this.source = source;
        this.type = type;
        this.context.put("message", message);
        this.context.put("source", this.context.localize(".text.npcNames." + source));
        this.context.put("dialogueType", this.context.localize(".text.dialogueTypes." + type));
    }

    @Override
    public Boolean isComplete() {
        return this.source != null && this.message != null;
    }
}

