/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.buffers;

import com.megacrit.cardcrawl.helpers.PowerTip;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.Buffer;
import sayTheSpire.ui.elements.MonsterElement;

public class MonsterBuffer
extends Buffer {
    private MonsterElement monster = null;

    public MonsterBuffer(String name) {
        super("monster", name);
    }

    @Override
    public Object getObject() {
        return this.monster;
    }

    @Override
    public void setObject(Object object) {
        this.monster = (MonsterElement)object;
    }

    @Override
    public void update() {
        this.clear();
        if (this.monster == null) {
            this.addLocalized("noObj");
            return;
        }
        this.context.put("hp", this.monster.getCurrentHealth());
        this.context.put("hpMax", this.monster.getMaxHealth());
        this.context.put("block", this.monster.getCurrentBlock());
        this.add(this.monster.getName());
        this.addLocalized("content.hp");
        this.addLocalized("content.block");
        this.add(this.monster.getPowersString());
        for (PowerTip tip : this.monster.getTips()) {
            this.add(TextParser.parse(tip.header + " NL " + tip.body));
        }
    }
}

