/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.buffers;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.Buffer;
import sayTheSpire.utils.CardUtils;

public class CardBuffer
extends Buffer {
    private AbstractCard card = null;
    private Boolean isUpgradePreview;
    private boolean noFurtherUpgrade;

    public CardBuffer(String name) {
        this(name, false);
    }

    public CardBuffer(String name, Boolean isUpgradePreview) {
        super("card", name);
        this.isUpgradePreview = isUpgradePreview;
        this.noFurtherUpgrade = false;
    }

    @Override
    public String getLocalizedName() {
        switch (this.getName()) {
            case "current card": {
                return this.context.localize("localizedName");
            }
            case "upgrade preview": {
                return this.context.localize("localizedNameUpgraded");
            }
        }
        return super.getLocalizedName();
    }

    @Override
    public Object getObject() {
        return this.card;
    }

    @Override
    public void setObject(Object object) {
        AbstractCard card = (AbstractCard)object;
        if (card == null) {
            this.card = null;
            return;
        }
        if (this.isUpgradePreview.booleanValue()) {
            if (!card.canUpgrade()) {
                this.noFurtherUpgrade = true;
            } else {
                this.noFurtherUpgrade = false;
                AbstractCard upgradedCard = card.makeStatEquivalentCopy();
                upgradedCard.upgrade();
                upgradedCard.isLocked = card.isLocked;
                upgradedCard.isFlipped = card.isFlipped;
                card = upgradedCard;
            }
        }
        this.card = card;
    }

    @Override
    public void update() {
        this.clear();
        if (this.card == null) {
            this.addLocalized("noObj");
            return;
        }
        if (this.card.isLocked) {
            this.add(AbstractCard.LOCKED_STRING);
            return;
        }
        if (this.card.isFlipped) {
            this.addLocalized("faceDown");
            return;
        }
        if (this.isUpgradePreview.booleanValue() && this.noFurtherUpgrade) {
            this.addLocalized("noFurtherUpgrade");
            return;
        }
        this.context.put("cost", CardUtils.getCardCostString(this.card));
        this.context.put("type", CardUtils.getCardTypeString(this.card));
        this.context.put("rarity", CardUtils.getCardRarityString(this.card));
        this.add(this.card.name);
        this.addLocalized("content.cost");
        this.addLocalized("content.typeAndRarity");
        this.add(CardUtils.getCardDescriptionString(this.card));
        for (String keyword : this.card.keywords) {
            String body;
            String name = TextParser.parse(keyword);
            if (name.equals("")) {
                name = keyword;
            }
            if ((body = (String)GameDictionary.keywords.get(keyword)) == null) {
                this.context.put("unknownKeyword", name);
                this.addLocalized("content.unknownKeyword");
                continue;
            }
            body = TextParser.parse(body);
            this.add(name + "\n" + body);
        }
    }
}

