/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.buffers;

import java.util.ArrayList;
import sayTheSpire.buffers.Buffer;

public class BufferManager {
    private ArrayList<Buffer> buffers = new ArrayList();
    private int position = -1;

    public void add(Buffer toAdd) {
        this.buffers.add(toAdd);
    }

    public Boolean enableBuffer(String name, Boolean enabled) {
        Buffer buffer = this.getBuffer(name);
        if (buffer == null) {
            return false;
        }
        buffer.setEnabled(enabled);
        if (!enabled.booleanValue() && buffer == this.getCurrentBuffer()) {
            this.moveToPrevious();
        } else if (enabled.booleanValue() && this.position == -1) {
            this.position = this.buffers.indexOf(buffer);
            buffer.update();
        }
        return true;
    }

    public int moveToNext() {
        if (this.buffers.isEmpty()) {
            this.position = -1;
            return -1;
        }
        int currentPosition = this.position;
        for (int b = currentPosition + 1; b != this.position; ++b) {
            if (b >= this.buffers.size()) {
                b = -1;
                continue;
            }
            if (!this.buffers.get(b).getEnabled().booleanValue()) continue;
            currentPosition = b;
            this.buffers.get(b).update();
            break;
        }
        this.position = currentPosition;
        return currentPosition;
    }

    public int moveToPrevious() {
        if (this.buffers.isEmpty()) {
            this.position = -1;
            return -1;
        }
        int currentPosition = this.position;
        for (int b = currentPosition - 1; b != this.position; --b) {
            if (b < 0) {
                b = this.buffers.size();
                continue;
            }
            if (!this.buffers.get(b).getEnabled().booleanValue()) continue;
            this.buffers.get(b).update();
            currentPosition = b;
            break;
        }
        this.position = currentPosition;
        return currentPosition;
    }

    public void setAllEnabled(Boolean enabled) {
        if (!enabled.booleanValue()) {
            this.position = -1;
        }
        for (Buffer buffer : this.buffers) {
            buffer.setEnabled(enabled);
        }
    }

    public void updateAll() {
        for (Buffer buffer : this.buffers) {
            buffer.update();
        }
    }

    public Buffer getBuffer(String name) {
        for (Buffer buffer : this.buffers) {
            if (!buffer.getName().equals(name)) continue;
            return buffer;
        }
        return null;
    }

    public ArrayList<Buffer> getBuffers() {
        return this.buffers;
    }

    public Buffer getCurrentBuffer() {
        if (this.position < 0 || this.buffers.isEmpty()) {
            return null;
        }
        Buffer buffer = this.buffers.get(this.position);
        if (!buffer.getEnabled().booleanValue()) {
            return null;
        }
        return buffer;
    }

    public void setCurrentBuffer(String name) {
        for (int b = 0; b < this.buffers.size(); ++b) {
            Buffer test = this.buffers.get(b);
            if (!test.getName().equals(name)) continue;
            test.update();
            this.position = b;
            return;
        }
    }

    public int getPosition() {
        return this.position;
    }
}

