/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire;

import com.megacrit.cardcrawl.blights.AbstractBlight;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import java.util.HashMap;
import java.util.Map;
import sayTheSpire.utils.CardUtils;
import sayTheSpire.utils.OutputUtils;

public class TextParser {
    public static String handleWordCardContext(String word) {
        word = TextParser.handleWordEmphasized(word);
        return word;
    }

    public static String handleWordDynamicVariables(String word, HashMap<String, String> dynamicVariables) {
        if (word == null || dynamicVariables == null) {
            return word;
        }
        word = word.trim();
        for (Map.Entry<String, String> entry : dynamicVariables.entrySet()) {
            String variable = entry.getKey();
            String value = entry.getValue();
            if (!word.contains("!" + variable + "!")) continue;
            word = word.replaceAll("\\!" + variable + "\\!", value);
        }
        return word;
    }

    public static String handleWordEmphasized(String word) {
        if (!word.startsWith("*") || word.length() < 2) {
            return word;
        }
        return word.substring(1);
    }

    public static String handleWordEnergies(String word) {
        for (Map.Entry<String, String> entry : OutputUtils.getValidEnergyTypes().entrySet()) {
            word = word.replaceAll("\\[" + entry.getKey() + "\\]", entry.getValue());
        }
        return word;
    }

    public static String handleWordRelicContext(String word) {
        return word;
    }

    public static String extractMainWord(String word) {
        if (TextParser.hasColor(word)) {
            word = word.substring(2);
        }
        if (word.length() < 2) {
            return word;
        }
        if (word.charAt(0) == '~' && word.charAt(word.length() - 1) == '~') {
            word = word.substring(1, word.length() - 1);
        } else if (word.charAt(0) == '@' && word.charAt(word.length() - 1) == '@') {
            word = word.substring(1, word.length() - 1);
        }
        return word;
    }

    public static boolean hasColor(String word) {
        if (word.length() < 2 || word.charAt(0) != '#') {
            return false;
        }
        char c = word.charAt(1);
        return c == 'r' || c == 'g' || c == 'b' || c == 'y' || c == 'p';
    }

    public static Boolean hasOrb(String word) {
        return word.equals("[E]") || word.equals("[R]") || word.equals("[G]") || word.equals("[B]") || word.equals("[W]") || word.equals("[C]") || word.equals("[P]") || word.equals("[T]") || word.equals("[S]");
    }

    public static String parse(String text) {
        return TextParser.parse(text, "", null);
    }

    public static String parse(String text, String context) {
        return TextParser.parse(text, context, null);
    }

    public static String parse(String text, String context, HashMap<String, String> dynamicVariables) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 0) {
            return text;
        }
        if (text.equals("")) {
            return text;
        }
        text = text.replaceAll("\n", " NL ");
        StringBuilder sb = new StringBuilder();
        for (String word : text.split(" ")) {
            if (word.equals("")) continue;
            if ((word = TextParser.extractMainWord(word)).equals("NL")) {
                sb.append("\n");
                continue;
            }
            if (word.equals("TAB")) {
                sb.append("\t");
                continue;
            }
            if (context.equals("card")) {
                word = TextParser.handleWordCardContext(word);
            } else if (context.equals("relic")) {
                word = TextParser.handleWordRelicContext(word);
            }
            word = TextParser.handleWordEnergies(word);
            word = TextParser.handleWordDynamicVariables(word, dynamicVariables);
            if (TextParser.hasOrb(word).booleanValue()) continue;
            sb.append(word + " ");
        }
        return sb.toString();
    }

    public static String parse(String text, AbstractCard card) {
        return TextParser.parse(text, "card", CardUtils.getCardDynamicVariables(card));
    }

    public static String parse(String text, AbstractPotion potion) {
        return TextParser.parse(text, "potion");
    }

    public static String parse(String text, AbstractBlight blight) {
        return TextParser.parse(text, "blight");
    }

    public static String parse(String text, AbstractRelic relic) {
        return TextParser.parse(text, "relic");
    }
}

