/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire;

import com.evacipated.cardcrawl.modthespire.lib.ConfigUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sayTheSpire.Output;
import sayTheSpire.ui.input.InputActionCollection;

public class STSConfig {
    private static final Logger logger = LogManager.getLogger((String)STSConfig.class.getName());
    private Toml settingsToml;
    private HashSet<String> excludedTypenames;
    private JsonObject inputObj;

    public STSConfig() {
        File dir = new File(STSConfig.getDirectoryPath());
        dir.mkdirs();
        this.loadInput();
        this.loadSettings();
        this.excludedTypenames = null;
    }

    private void loadInput() {
        try {
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse((Reader)new FileReader(this.getInputFilePath()));
            this.inputObj = root.getAsJsonObject();
            logger.info("Input settings file loaded successfully.");
        }
        catch (Exception e) {
            logger.info("Issue loading input mappings file.");
            e.printStackTrace();
            this.inputObj = null;
        }
    }

    private void loadSettings() {
        File file = new File(STSConfig.getSettingsFilePath());
        HashMap<String, Object> defaults = this.getDefaults();
        try {
            HashMap fileSettings = (HashMap)new Toml().read(file).toMap();
            STSConfig.merge(defaults, fileSettings);
            this.settingsToml = new Toml().read(new TomlWriter().write(defaults));
            logger.info("Config loaded from existing file.");
        }
        catch (Exception e) {
            logger.info("No config file found, using defaults.");
            this.settingsToml = new Toml().read(new TomlWriter().write(defaults));
        }
    }

    public static void merge(HashMap<String, Object> base, HashMap<String, Object> merger) {
        for (Map.Entry<String, Object> entry : merger.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (base.containsKey(key) && base.get(key) instanceof HashMap && value instanceof HashMap) {
                STSConfig.merge((HashMap)base.get(key), (HashMap)value);
                continue;
            }
            base.put(key, value);
        }
    }

    public void save() throws IOException {
        Throwable throwable;
        FileWriter file;
        try {
            file = new FileWriter(STSConfig.getSettingsFilePath());
            throwable = null;
            try {
                TomlWriter writer = new TomlWriter();
                writer.write(this.settingsToml.toMap(), file);
                file.flush();
                logger.info("Successfully wrote settings file.");
            }
            catch (Throwable writer) {
                throwable = writer;
                throw writer;
            }
            finally {
                if (file != null) {
                    if (throwable != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable writer) {
                            throwable.addSuppressed(writer);
                        }
                    } else {
                        file.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Issue writing to settings file.");
            e.printStackTrace();
        }
        try {
            file = new FileWriter(STSConfig.getInputFilePath());
            throwable = null;
            try {
                InputActionCollection actions = Output.inputManager.getActionCollection();
                JsonElement json = actions.toJsonElement();
                file.write(json.toString());
                file.flush();
                logger.info("Successfully wrote input mappings file.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (file != null) {
                    if (throwable != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        file.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error writing to input mappings file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static HashMap<String, Object> getDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        HashMap<String, Boolean> resourceDefaults = new HashMap<String, Boolean>();
        resourceDefaults.put("dispose_resource_files", true);
        resourceDefaults.put("unload_native_libs", true);
        HashMap<String, Serializable> uiDefaults = new HashMap<String, Serializable>();
        uiDefaults.put("read_positions", Boolean.valueOf(true));
        uiDefaults.put("read_banner_text", Boolean.valueOf(true));
        uiDefaults.put("read_proceed_text", Boolean.valueOf(true));
        uiDefaults.put("read_types", Boolean.valueOf(true));
        uiDefaults.put("exclude_read_typenames", new ArrayList());
        uiDefaults.put("read_obtain_events", Boolean.valueOf(true));
        HashMap<String, Boolean> mapDefaults = new HashMap<String, Boolean>();
        mapDefaults.put("read_reversed_paths", true);
        HashMap<String, Boolean> combatDefaults = new HashMap<String, Boolean>();
        combatDefaults.put("block_text", true);
        combatDefaults.put("buff_debuff_text", true);
        combatDefaults.put("card_events", true);
        combatDefaults.put("orb_events", true);
        HashMap<String, Boolean> inputDefaults = new HashMap<String, Boolean>();
        inputDefaults.put("virtual_input", true);
        HashMap<String, Serializable> advancedDefaults = new HashMap<String, Serializable>();
        advancedDefaults.put("use_updated_card_description", Boolean.valueOf(false));
        advancedDefaults.put("prefered_speech_handler_order", new ArrayList());
        advancedDefaults.put("speech_handler_force_system_speech", Boolean.valueOf(false));
        defaults.put("resources", resourceDefaults);
        defaults.put("ui", uiDefaults);
        defaults.put("map", mapDefaults);
        defaults.put("combat", combatDefaults);
        defaults.put("input", inputDefaults);
        defaults.put("advanced", advancedDefaults);
        return defaults;
    }

    public HashSet<String> getExcludedTypenames() {
        if (this.excludedTypenames == null) {
            this.excludedTypenames = new HashSet(this.getList("ui.exclude_read_typenames", new ArrayList()));
        }
        return this.excludedTypenames;
    }

    public static String getDirectoryPath() {
        return ConfigUtils.CONFIG_DIR + File.separator + "sayTheSpire" + File.separator;
    }

    public static String getInputFilePath() {
        return STSConfig.getDirectoryPath() + "input.json";
    }

    public JsonObject getInputObj() {
        return this.inputObj;
    }

    public static String getSettingsFilePath() {
        return STSConfig.getDirectoryPath() + "settings.ini";
    }

    public String getString(String key) {
        return this.settingsToml.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.settingsToml.getString(key, defaultValue);
    }

    public Long getLong(String key) {
        return this.settingsToml.getLong(key);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.settingsToml.getLong(key, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.settingsToml.getBoolean(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.settingsToml.getBoolean(key, defaultValue);
    }

    public Double getDouble(String key) {
        return this.settingsToml.getDouble(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.settingsToml.getDouble(key, defaultValue);
    }

    public List getList(String key) {
        return this.settingsToml.getList(key);
    }

    public List getList(String key, List defaultValue) {
        return this.settingsToml.getList(key, defaultValue);
    }
}

