/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire;

import com.megacrit.cardcrawl.map.MapRoomNode;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sayTheSpire.BufferControls;
import sayTheSpire.InfoControls;
import sayTheSpire.MiscTriggers;
import sayTheSpire.STSConfig;
import sayTheSpire.buffers.BlightBuffer;
import sayTheSpire.buffers.Buffer;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.buffers.CardBuffer;
import sayTheSpire.buffers.EventBuffer;
import sayTheSpire.buffers.LeaderboardBuffer;
import sayTheSpire.buffers.MonsterBuffer;
import sayTheSpire.buffers.OrbBuffer;
import sayTheSpire.buffers.PlayerBuffer;
import sayTheSpire.buffers.PotionBuffer;
import sayTheSpire.buffers.RelicBuffer;
import sayTheSpire.events.Event;
import sayTheSpire.events.EventManager;
import sayTheSpire.localization.LocalizationContext;
import sayTheSpire.localization.LocalizationManager;
import sayTheSpire.speech.SpeechManager;
import sayTheSpire.ui.UIRegistry;
import sayTheSpire.ui.effects.EffectManager;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.input.InputManager;
import sayTheSpire.ui.mod.MapManager;
import sayTheSpire.ui.mod.UIManager;

public class Output {
    public static String modVersion = "0.5.0-beta";
    private static Logger logger = LogManager.getLogger((String)Output.class.getName());
    public static BufferManager buffers = new BufferManager();
    public static Boolean tolkSetup = false;
    public static Boolean shouldInterruptSpeech = false;
    public static EffectManager effects = null;
    public static InputManager inputManager = null;
    public static MapManager mapManager = null;
    public static UIManager uiManager = null;
    public static SpeechManager speechManager = null;
    public static LocalizationManager localization;
    public static String eventText;
    public static UIElement currentUI;
    public static STSConfig config;

    public static void announceVersion() {
        Output.text(localization.localize("misc.versionString", "version", modVersion), false);
    }

    public static void preSetup() {
        localization = new LocalizationManager();
    }

    public static void postSetup() {
        localization.postSetupLoad();
        effects = new EffectManager();
        try {
            config = new STSConfig();
            inputManager = new InputManager(config.getInputObj());
            config.save();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            inputManager = new InputManager();
        }
        mapManager = new MapManager();
        uiManager = new UIManager(inputManager, mapManager);
        speechManager = new SpeechManager();
        speechManager.setup();
        tolkSetup = true;
        Output.setupBuffers();
    }

    private static void setupBuffers() {
        BufferControls.buffers = buffers;
        buffers.add(new Buffer("unknown", "UI"));
        buffers.add(new Buffer("unknown", "UI extra"));
        buffers.add(new LeaderboardBuffer());
        buffers.add(new CardBuffer("current card"));
        buffers.add(new CardBuffer("upgrade preview", true));
        buffers.add(new EventBuffer("events"));
        buffers.add(new PlayerBuffer());
        buffers.add(new OrbBuffer("orb"));
        buffers.add(new MonsterBuffer("monster"));
        buffers.add(new PotionBuffer("potion"));
        buffers.add(new BlightBuffer("blight"));
        buffers.add(new RelicBuffer("relic"));
    }

    public static void shutdown() {
        try {
            config.save();
            speechManager.unload();
            if (config.getBoolean("resources.dispose_resource_files").booleanValue()) {
                speechManager.disposeResources();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public static void event(Event event) {
        EventManager.add(event);
    }

    public static void forceSpeechInterrupt() {
        shouldInterruptSpeech = true;
    }

    public static void silenceSpeech() {
        speechManager.silence();
    }

    public static void text(String text, Boolean interrupt) {
        if (text == null) {
            speechManager.output("Warning: output null text, report to mod dev", shouldInterruptSpeech != false && interrupt != false);
            return;
        }
        speechManager.output(text, shouldInterruptSpeech != false && interrupt != false);
        shouldInterruptSpeech = interrupt;
    }

    public static void textLocalized(String path, Boolean interrupt, LocalizationContext context) {
        Output.text(context.localize(path), interrupt);
    }

    public static void textLocalized(String path, Boolean interrupt, Object ... variables) {
        LocalizationContext context = localization.getContext("");
        int length = variables.length;
        if (length % 2 == 0) {
            for (int i = 0; i < length; i += 2) {
                String name = (String)variables[i];
                Object value = variables[i + 1];
                context.put(name, value);
            }
        }
        Output.text(context.localize(path), interrupt);
    }

    public static Boolean getAllowVirtualInput() {
        if (uiManager == null) {
            return false;
        }
        return uiManager.getAllowVirtualInput() != false && config.getBoolean("input.virtual_input", false) != false;
    }

    public static void setupBuffers(MapRoomNode node, Boolean isHovered, Boolean shouldAnnounce) {
        InfoControls.bufferContext = "map";
        mapManager.handleNode(node, isHovered, shouldAnnounce);
    }

    public static void setUI(UIElement element) {
        InfoControls.bufferContext = "buffers";
        buffers.setAllEnabled(false);
        String current = element.handleBuffers(buffers);
        currentUI = element;
        String focusString = element.getFocusString();
        Output.text(focusString, false);
        if (current == null) {
            return;
        }
        BufferControls.setCurrentBuffer(current);
    }

    public static void setupUIBuffer(ArrayList<String> contents) {
        InfoControls.bufferContext = "buffers";
        Buffer buffer = buffers.getBuffer("UI");
        buffer.clear();
        buffer.addMany(contents);
        buffers.enableBuffer("UI", true);
        BufferControls.setCurrentBuffer("UI");
    }

    public static void setupUIBufferMany(String ... contents) {
        InfoControls.bufferContext = "buffers";
        Buffer buffer = buffers.getBuffer("UI");
        buffer.clear();
        for (String s : contents) {
            buffer.add(s);
        }
        buffers.enableBuffer("UI", true);
        BufferControls.setCurrentBuffer("UI");
    }

    public static void update() {
        MiscTriggers.update();
        EventManager.update();
        UIRegistry.update();
    }

    static {
        eventText = null;
        currentUI = null;
        config = null;
    }
}

