/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire;

import sayTheSpire.Output;
import sayTheSpire.buffers.Buffer;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.localization.LocalizationContext;

public class BufferControls {
    public static BufferManager buffers = null;

    public static void nextBuffer() {
        buffers.moveToNext();
        BufferControls.reportCurrentBuffer();
    }

    public static void nextItem() {
        Buffer current = buffers.getCurrentBuffer();
        if (current != null) {
            current.moveToNext();
        }
        BufferControls.reportCurrentItem(current);
    }

    public static void previousBuffer() {
        buffers.moveToPrevious();
        BufferControls.reportCurrentBuffer();
    }

    public static void previousItem() {
        Buffer current = buffers.getCurrentBuffer();
        if (current != null) {
            current.moveToPrevious();
        }
        BufferControls.reportCurrentItem(current);
    }

    public static void reportCurrentBuffer() {
        Buffer current = buffers.getCurrentBuffer();
        LocalizationContext context = Output.localization.getContext("text.buffers");
        context.put("buffer", current.getLocalizedName());
        String currentItem = current.getCurrentItem();
        context.put("item", currentItem);
        if (current == null) {
            Output.textLocalized("noBuffersAvailable", (Boolean)true, context);
            return;
        }
        if (current.isEmpty().booleanValue()) {
            Output.textLocalized("bufferIsEmpty", (Boolean)true, context);
            return;
        }
        if (currentItem == null) {
            Output.textLocalized("currentItemIsNull", (Boolean)true, context);
            return;
        }
        Output.textLocalized("currentItem", (Boolean)true, context);
    }

    public static void reportCurrentItem(Buffer buffer) {
        LocalizationContext context = Output.localization.getContext("text.buffers");
        if (buffer == null) {
            Output.textLocalized("noBufferSelected", (Boolean)false, context);
            return;
        }
        context.put("buffer", buffer.getLocalizedName());
        String currentItem = buffer.getCurrentItem();
        context.put("item", currentItem);
        if (buffer.isEmpty().booleanValue()) {
            Output.textLocalized("bufferIsEmpty", (Boolean)true, context);
            return;
        }
        if (currentItem == null) {
            Output.textLocalized("currentItemIsNull", (Boolean)false, context);
            return;
        }
        Output.text(currentItem, true);
    }

    public static void setCurrentBuffer(String name) {
        buffers.setCurrentBuffer(name);
    }
}

