/*
 * Decompiled with CFR 0.152.
 */
package org.bigtesting.interpolatd.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bigtesting.interpolatd.SubstitutionHandler;
import org.bigtesting.interpolatd.Substitutor;
import org.bigtesting.interpolatd.core.Interpolating;
import org.bigtesting.interpolatd.core.Substitution;

public abstract class SubstitutionHandlerImpl<T>
implements SubstitutionHandler<T>,
Interpolating<T> {
    protected Substitutor<T> substitutor;

    @Override
    public void handleWith(Substitutor<T> substitutor) {
        this.substitutor = substitutor;
    }

    protected abstract Pattern getPattern();

    protected abstract String getCaptured(String var1);

    @Override
    public List<Substitution> interpolate(String toInterpolate, T arg) {
        ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
        if (this.substitutor != null) {
            Matcher m = this.getPattern().matcher(toInterpolate);
            while (m.find()) {
                String found = m.group(1);
                String captured = this.getCaptured(found);
                String substitution = this.substitutor.substitute(captured, arg);
                substitutions.add(new Substitution(found, substitution, m.start(), m.end()));
            }
        }
        return substitutions;
    }
}

