/*
 * Decompiled with CFR 0.152.
 */
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.screens.stats.AchievementItem;
import com.megacrit.cardcrawl.screens.stats.CharStat;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import java.util.ArrayList;
import sayTheSpire.Output;
import sayTheSpire.ui.elements.AchievementElement;
import sayTheSpire.ui.elements.StatElement;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.positions.CategoryListPosition;
import sayTheSpire.ui.positions.Position;

public class StatsScreenPatch {

    @SpirePatch(clz=StatsScreen.class, method="update")
    public static class UpdatePatch {
        private static Hitbox currentHitbox = null;

        private static AchievementElement getHoveredAchievement(StatsScreen screen) {
            int achievementCount = StatsScreen.achievements.items.size();
            for (int i = 0; i < achievementCount; ++i) {
                AchievementItem achievement = (AchievementItem)StatsScreen.achievements.items.get(i);
                if (achievement.hb != currentHitbox) continue;
                return new AchievementElement(achievement, (Position)new CategoryListPosition(i, achievementCount, "achievements"));
            }
            return null;
        }

        private static StatElement getHoveredCharacter(StatsScreen screen) {
            Hitbox[] hitboxes = new Hitbox[]{screen.allCharsHb, screen.ironcladHb, screen.silentHb, screen.defectHb, screen.watcherHb};
            ArrayList stats = CardCrawlGame.characterManager.getAllCharacterStats();
            stats.add(0, StatsScreen.all);
            int statCount = stats.size();
            for (int h = 0; h < statCount; ++h) {
                if (hitboxes[h] != currentHitbox) continue;
                String name = "all";
                if (h > 0) {
                    name = ((AbstractPlayer)CardCrawlGame.characterManager.getAllCharacters().get((int)(h - 1))).title;
                }
                return new StatElement(name, (CharStat)stats.get(h));
            }
            return null;
        }

        private static UIElement getHoveredElement(StatsScreen screen) {
            StatElement character = UpdatePatch.getHoveredCharacter(screen);
            if (character != null) {
                return character;
            }
            AchievementElement achievement = UpdatePatch.getHoveredAchievement(screen);
            if (achievement != null) {
                return achievement;
            }
            return null;
        }

        public static void Postfix(StatsScreen __instance) {
            if (__instance.controllerHb != currentHitbox) {
                currentHitbox = __instance.controllerHb;
                UIElement element = UpdatePatch.getHoveredElement(__instance);
                if (element != null) {
                    Output.setUI(element);
                }
            }
        }
    }
}

