/*
 * Decompiled with CFR 0.152.
 */
import basemod.ReflectionHacks;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.daily.mods.AbstractDailyMod;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.screens.options.DropdownMenu;
import com.megacrit.cardcrawl.screens.runHistory.CopyableTextElement;
import com.megacrit.cardcrawl.screens.runHistory.ModIcons;
import com.megacrit.cardcrawl.screens.runHistory.RunHistoryPath;
import com.megacrit.cardcrawl.screens.runHistory.RunHistoryScreen;
import com.megacrit.cardcrawl.screens.runHistory.RunPathElement;
import com.megacrit.cardcrawl.screens.runHistory.TinyCard;
import com.megacrit.cardcrawl.screens.stats.RunData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sayTheSpire.Output;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.Buffer;
import sayTheSpire.ui.UIRegistry;
import sayTheSpire.ui.elements.CardElement;
import sayTheSpire.ui.elements.DropdownElement;
import sayTheSpire.ui.elements.RelicElement;
import sayTheSpire.ui.elements.RunPathViewElement;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.positions.GridPosition;
import sayTheSpire.ui.positions.Position;

public class RunHistoryScreenPatches {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("RunHistoryScreen");
    public static final String[] TEXT = RunHistoryScreenPatches.uiStrings.TEXT;
    private static Object prevHovered = null;

    public static DropdownMenu getDropdown(RunHistoryScreen screen, String name) {
        return (DropdownMenu)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)name);
    }

    public static Boolean dropdownHovered(DropdownMenu dropdown) {
        if (dropdown.rows.isEmpty()) {
            return false;
        }
        Hitbox hb = dropdown.getHitbox();
        if (hb == null) {
            return false;
        }
        return hb.hovered;
    }

    public static Object getHovered(RunHistoryScreen screen) {
        ArrayList relics;
        DropdownMenu runsDropdown = RunHistoryScreenPatches.getDropdown(screen, "runsDropdown");
        if (RunHistoryScreenPatches.dropdownHovered(runsDropdown).booleanValue()) {
            return runsDropdown;
        }
        DropdownMenu characterFilter = RunHistoryScreenPatches.getDropdown(screen, "characterFilter");
        if (RunHistoryScreenPatches.dropdownHovered(characterFilter).booleanValue()) {
            return characterFilter;
        }
        DropdownMenu winLossFilter = RunHistoryScreenPatches.getDropdown(screen, "winLossFilter");
        if (RunHistoryScreenPatches.dropdownHovered(winLossFilter).booleanValue()) {
            return winLossFilter;
        }
        DropdownMenu runTypeFilter = RunHistoryScreenPatches.getDropdown(screen, "runTypeFilter");
        if (RunHistoryScreenPatches.dropdownHovered(runTypeFilter).booleanValue()) {
            return runTypeFilter;
        }
        ArrayList cards = (ArrayList)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"cards");
        for (Object card : cards) {
            if (!((TinyCard)card).hb.hovered) continue;
            return card;
        }
        RunHistoryPath path = (RunHistoryPath)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"runPath");
        if (path != null) {
            for (RunPathElement e : path.pathElements) {
                if (!e.hb.hovered) continue;
                return e;
            }
        }
        if ((relics = (ArrayList)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"relics")) != null) {
            for (AbstractRelic relic : relics) {
                if (!relic.hb.hovered) continue;
                return relic;
            }
        }
        return null;
    }

    static void setupExtraBuffer(RunHistoryScreen screen) {
        Buffer buffer = Output.buffers.getBuffer("UI extra");
        if (buffer == null) {
            return;
        }
        buffer.clear();
        buffer.setEnabled(true);
        RunData data = (RunData)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"viewedRun");
        if (data == null) {
            buffer.add(TextParser.parse(TEXT[4]));
        } else {
            try {
                CopyableTextElement customSeed;
                String customSeedText;
                Method characterText = RunHistoryScreen.class.getDeclaredMethod("characterText", String.class);
                characterText.setAccessible(true);
                String name = (String)characterText.invoke((Object)screen, data.character_chosen);
                buffer.add(name);
                CopyableTextElement seed = (CopyableTextElement)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"seedElement");
                String seedText = seed.getText();
                if (seedText != null && !seedText.isEmpty()) {
                    buffer.add(seedText);
                }
                if ((customSeedText = (customSeed = (CopyableTextElement)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"secondSeedElement")).getText()) != null && !customSeedText.isEmpty()) {
                    buffer.add(customSeedText);
                }
                String specialMode = "";
                if (data.is_daily) {
                    specialMode = TEXT[27];
                } else if (data.is_ascension_mode) {
                    specialMode = TEXT[5] + data.ascension_level;
                }
                String result = "";
                result = data.victory ? TEXT[8] + specialMode : (data.killed_by == null ? String.format(TEXT[7], data.floor_reached) + specialMode : String.format(TEXT[6], data.floor_reached, MonsterHelper.getEncounterName((String)data.killed_by)) + specialMode);
                buffer.add(result);
                buffer.add(String.format(TEXT[22], data.score));
                ModIcons icons = (ModIcons)ReflectionHacks.getPrivate((Object)screen, RunHistoryScreen.class, (String)"modIcons");
                ArrayList mods = (ArrayList)ReflectionHacks.getPrivate((Object)icons, ModIcons.class, (String)"dailyModList");
                for (AbstractDailyMod m : mods) {
                    buffer.add(m.name + "\n" + m.description);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    @SpirePatch(clz=RunHistoryScreen.class, method="update")
    public static class UpdatePatch {
        public static void Postfix(RunHistoryScreen __instance) {
            Object hovered = RunHistoryScreenPatches.getHovered(__instance);
            if (hovered != null && hovered != prevHovered) {
                UIElement element = UIRegistry.getUI(hovered);
                if (element != null) {
                    Output.setUI(element);
                } else if (hovered instanceof TinyCard) {
                    TinyCard card = (TinyCard)hovered;
                    Output.setUI(new CardElement(card.card, CardElement.CardLocation.OTHER, new GridPosition(card.col + 1, card.row + 1)));
                } else if (hovered instanceof RunPathElement) {
                    RunPathElement path = (RunPathElement)hovered;
                    Output.setUI(new RunPathViewElement(path, (Position)new GridPosition(path.col + 1, path.row + 1)));
                } else if (hovered instanceof AbstractRelic) {
                    int index;
                    AbstractRelic relic = (AbstractRelic)hovered;
                    ArrayList relics = (ArrayList)ReflectionHacks.getPrivate((Object)__instance, RunHistoryScreen.class, (String)"relics");
                    GridPosition position = null;
                    if (relics != null && (index = relics.indexOf(relic)) >= 0) {
                        position = new GridPosition(index % 15 + 1, index / 15 + 1);
                    }
                    Output.setUI(new RelicElement(relic, RelicElement.RelicLocation.OTHER, position));
                }
                RunHistoryScreenPatches.setupExtraBuffer(__instance);
            }
            prevHovered = hovered;
        }
    }

    @SpirePatch(clz=RunHistoryScreen.class, method="refreshData")
    public static class RefreshDataPatch {
        public static void Postfix(RunHistoryScreen __instance) {
            DropdownMenu runsDropdown = RunHistoryScreenPatches.getDropdown(__instance, "runsDropdown");
            UIRegistry.register(runsDropdown, new DropdownElement(runsDropdown, "runs", false));
            DropdownMenu characterFilter = RunHistoryScreenPatches.getDropdown(__instance, "characterFilter");
            UIRegistry.register(characterFilter, new DropdownElement(characterFilter, "character filter", false));
            DropdownMenu winLossFilter = RunHistoryScreenPatches.getDropdown(__instance, "winLossFilter");
            UIRegistry.register(winLossFilter, new DropdownElement(winLossFilter, "win loss filter", false));
            DropdownMenu runTypeFilter = RunHistoryScreenPatches.getDropdown(__instance, "runTypeFilter");
            UIRegistry.register(runTypeFilter, new DropdownElement(runTypeFilter, "run type", false));
        }
    }

    @SpirePatch(clz=RunHistoryScreen.class, method="changedSelectionTo")
    public static class ChangedSelectionToPatch {
        public static void Postfix(RunHistoryScreen __instance) {
            DropdownMenu runsDropdown = RunHistoryScreenPatches.getDropdown(__instance, "runsDropdown");
            UIRegistry.register(runsDropdown, new DropdownElement(runsDropdown, "runs"));
        }
    }
}

