/*
 * Decompiled with CFR 0.152.
 */
import basemod.ReflectionHacks;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.events.shrines.GremlinMatchGame;
import com.megacrit.cardcrawl.localization.EventStrings;
import sayTheSpire.Output;
import sayTheSpire.TextParser;
import sayTheSpire.ui.UIRegistry;
import sayTheSpire.ui.custom.GremlinMatchCardElement;
import sayTheSpire.ui.positions.GridPosition;
import sayTheSpire.ui.positions.Position;

public class GremlinMatchGamePatch {
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Match and Keep!");
    public static final String[] OPTIONS = GremlinMatchGamePatch.eventStrings.OPTIONS;

    @SpirePatch(clz=GremlinMatchGame.class, method="updateMatchGameLogic")
    public static class UpdateGameMatchLogicPatch {
        public static int prevAttemptCount = -1;

        public static void Postfix(GremlinMatchGame __instance) {
            AbstractCard hoveredCard;
            GremlinMatchCardElement element;
            CardGroup cards = (CardGroup)ReflectionHacks.getPrivate((Object)__instance, GremlinMatchGame.class, (String)"cards");
            for (AbstractCard card : cards.group) {
                element = (GremlinMatchCardElement)UIRegistry.getUI(card);
                if (element == null) continue;
                element.handleFlip();
            }
            int attemptCount = (Integer)ReflectionHacks.getPrivate((Object)__instance, GremlinMatchGame.class, (String)"attemptCount");
            if (attemptCount != prevAttemptCount) {
                Output.text(TextParser.parse(OPTIONS[3] + attemptCount), false);
                prevAttemptCount = attemptCount;
            }
            if ((hoveredCard = (AbstractCard)ReflectionHacks.getPrivate((Object)__instance, GremlinMatchGame.class, (String)"hoveredCard")) == null) {
                return;
            }
            element = (GremlinMatchCardElement)UIRegistry.getUI(hoveredCard);
            if (element == null) {
                Output.text(Output.localization.localize("errors.unknownGremlinMatchCard", new Object[0]), false);
                return;
            }
            if (hoveredCard.hb.justHovered) {
                Output.setUI(element);
            }
        }
    }

    @SpirePatch(clz=GremlinMatchGame.class, method="<ctor>")
    public static class ConstructorPatch {
        public static void Postfix(GremlinMatchGame __instance) {
            CardGroup cards = (CardGroup)ReflectionHacks.getPrivate((Object)__instance, GremlinMatchGame.class, (String)"cards");
            for (int p = 0; p < 12; ++p) {
                AbstractCard card = (AbstractCard)cards.group.get(p);
                int x = p % 4 + 1;
                int y = p % 3 + 1;
                UIRegistry.register(card, new GremlinMatchCardElement(card, (Position)new GridPosition(x, y)));
            }
        }
    }
}

