/*
 * Decompiled with CFR 0.152.
 */
package textTheSpire;

import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.orbs.AbstractOrb;
import com.megacrit.cardcrawl.orbs.Dark;
import com.megacrit.cardcrawl.orbs.Frost;
import com.megacrit.cardcrawl.orbs.Lightning;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.GoldPlatedCables;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import communicationmod.CommandExecutor;
import guardian.characters.GuardianCharacter;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import textTheSpire.AbstractWindow;
import textTheSpire.TextTheSpire;
import textTheSpire.Window;

public class Orbs
extends AbstractWindow {
    public Orbs(Display display) {
        this.isVisible = true;
        this.window = new Window(display, "Orbs", 300, 300);
    }

    @Override
    public String getText() {
        if (this.window.shell.isDisposed()) {
            Display.getDefault().dispose();
            Gdx.app.exit();
        }
        StringBuilder s = new StringBuilder();
        s.append("\r\n");
        if (CardCrawlGame.dungeon == null || !CommandExecutor.isInDungeon() || !CardCrawlGame.isInARun()) {
            return "";
        }
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            AbstractPlayer p = AbstractDungeon.player;
            ArrayList ol = p.orbs;
            int frostTotal = 0;
            int lightningTotal = 0;
            for (AbstractOrb o : ol) {
                if (o instanceof Lightning) {
                    lightningTotal += o.passiveAmount;
                }
                if (!(o instanceof Frost)) continue;
                frostTotal += o.passiveAmount;
            }
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                if (!(r instanceof GoldPlatedCables)) continue;
                if (ol.get(0) instanceof Frost) {
                    frostTotal += ((AbstractOrb)ol.get((int)0)).passiveAmount;
                    break;
                }
                if (!(ol.get(0) instanceof Lightning)) break;
                lightningTotal += ((AbstractOrb)ol.get((int)0)).passiveAmount;
                break;
            }
            if (frostTotal > 0 || lightningTotal > 0) {
                s.append("End of Turn Passive Totals:\r\n");
                if (frostTotal > 0) {
                    s.append("Frost: ").append(frostTotal).append("\r\n");
                }
                if (lightningTotal > 0) {
                    s.append("Lightning: ").append(lightningTotal).append("\r\n");
                }
            }
            s.append("Front\r\n");
            int count = 0;
            for (AbstractOrb o : ol) {
                if (o instanceof Dark) {
                    s.append(count).append(". Dark ").append(o.evokeAmount).append("\r\n");
                } else if (TextTheSpire.downfall && AbstractDungeon.player instanceof GuardianCharacter) {
                    s.append(count).append(". ").append(o.name).append(" ").append(o.passiveAmount).append("\r\n");
                } else {
                    s.append(count).append(". ").append(o.name).append("\r\n");
                }
                ++count;
            }
            s.append("Back\r\n");
            return s.toString();
        }
        return "";
    }
}

