/*
 * Decompiled with CFR 0.152.
 */
package textTheSpire;

import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomElite;
import communicationmod.CommandExecutor;
import communicationmod.patches.DungeonMapPatch;
import communicationmod.patches.MapRoomNodeHoverPatch;
import downfall.patches.EvilModeCharacterSelect;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import replayTheSpire.patches.BonfirePatches;
import textTheSpire.AbstractWindow;
import textTheSpire.Inspect;
import textTheSpire.TextTheSpire;
import textTheSpire.Window;

public class Map
extends AbstractWindow {
    public Map(Display display) {
        this.isVisible = true;
        this.window = new Window(display, "Map", 550, 425);
    }

    @Override
    public String getText() {
        if (this.window.shell.isDisposed()) {
            Display.getDefault().dispose();
            Gdx.app.exit();
        }
        if (TextTheSpire.downfall && EvilModeCharacterSelect.evilMode) {
            return this.downfallMap();
        }
        if (Inspect.has_inspected && AbstractDungeon.currMapNode.y >= Inspect.destination.y) {
            Inspect.has_inspected = false;
        }
        StringBuilder s = new StringBuilder();
        s.append("\r\n");
        if (CommandExecutor.isInDungeon() && AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT) {
            s.append(AbstractDungeon.bossKey).append("\r\n");
            ArrayList m = AbstractDungeon.map;
            s.append("Current= Floor:").append(AbstractDungeon.currMapNode.y + 1).append(" X:").append(AbstractDungeon.currMapNode.x).append("\r\n");
            s.append("\r\n");
            if (AbstractDungeon.currMapNode.y == 15 || AbstractDungeon.currMapNode.y == -1) {
                int currFloor = AbstractDungeon.currMapNode.y;
                if (currFloor == 15) {
                    currFloor = -1;
                }
                for (int i = m.size() - 1; i >= currFloor + 1; --i) {
                    for (MapRoomNode n : (ArrayList)m.get(i)) {
                        if (!n.hasEdges()) continue;
                        s.append(Map.nodeType(n)).append("Floor:").append(i + 1).append(" X:").append(n.x).append("\r\n");
                    }
                    s.append("\r\n");
                }
            } else {
                StringBuilder limitedMap = new StringBuilder();
                ArrayList<MapRoomNode> current = new ArrayList<MapRoomNode>();
                ArrayList<MapRoomNode> prev = new ArrayList<MapRoomNode>();
                prev.add(AbstractDungeon.currMapNode);
                for (int i = AbstractDungeon.currMapNode.y + 1; i < m.size(); ++i) {
                    StringBuilder limitedFloor = new StringBuilder();
                    for (MapRoomNode n : (ArrayList)m.get(i)) {
                        StringBuilder limitedNode = new StringBuilder();
                        for (MapRoomNode child : prev) {
                            if (!child.isConnectedTo(n)) continue;
                            limitedNode.append(Map.nodeType(n)).append(" Floor:").append(i + 1).append(" X: ").append(n.x).append("\r\n");
                            break;
                        }
                        if (limitedNode.length() > 0) {
                            limitedFloor.append((CharSequence)limitedNode);
                            current.add(n);
                            continue;
                        }
                        if (!AbstractDungeon.player.hasRelic("WingedGreaves") || AbstractDungeon.player.getRelic((String)"WingedGreaves").counter <= 0 || n.getParents().size() <= 0) continue;
                        limitedFloor.append("Winged ").append(Map.nodeType(n)).append(" Floor:").append(i + 1).append(" X: ").append(n.x).append("\r\n");
                    }
                    limitedFloor.append("\r\n");
                    prev.clear();
                    prev.addAll(current);
                    current.clear();
                    limitedMap.insert(0, limitedFloor);
                }
                s.append((CharSequence)limitedMap);
            }
            return s.toString();
        }
        return "";
    }

    public String downfallMap() {
        StringBuilder s = new StringBuilder("\r\n");
        if (Inspect.has_inspected && AbstractDungeon.currMapNode.y <= Inspect.destination.y) {
            Inspect.has_inspected = false;
        }
        if (CommandExecutor.isInDungeon() && AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT) {
            s.append(AbstractDungeon.bossKey).append("\r\n");
            ArrayList m = AbstractDungeon.map;
            int currFloor = AbstractDungeon.currMapNode.y;
            if (currFloor == -1) {
                currFloor = 15;
            }
            s.append("Current= Floor:").append(currFloor + 1).append(" X:").append(AbstractDungeon.currMapNode.x).append("\r\n");
            s.append("\r\n");
            if (currFloor == 15) {
                for (int i = 0; i < m.size(); ++i) {
                    for (MapRoomNode n : (ArrayList)m.get(i)) {
                        if (!n.hasEdges()) continue;
                        s.append(Map.nodeType(n)).append("Floor:").append(i + 1).append(" X:").append(n.x).append("\r\n");
                    }
                    s.append("\r\n");
                }
            } else {
                StringBuilder limitedMap = new StringBuilder();
                ArrayList<MapRoomNode> current = new ArrayList<MapRoomNode>();
                ArrayList<MapRoomNode> prev = new ArrayList<MapRoomNode>();
                prev.add(AbstractDungeon.currMapNode);
                for (int i = AbstractDungeon.currMapNode.y - 1; i >= 0; --i) {
                    StringBuilder limitedFloor = new StringBuilder();
                    for (MapRoomNode n : (ArrayList)m.get(i)) {
                        StringBuilder limitedNode = new StringBuilder();
                        for (MapRoomNode child : prev) {
                            if (!child.isConnectedTo(n)) continue;
                            limitedNode.append(Map.nodeType(n)).append(" Floor:").append(i + 1).append(" X: ").append(n.x).append("\r\n");
                            break;
                        }
                        if (limitedNode.length() > 0) {
                            limitedFloor.append((CharSequence)limitedNode);
                            current.add(n);
                            continue;
                        }
                        if (!AbstractDungeon.player.hasRelic("WingedGreaves") || AbstractDungeon.player.getRelic((String)"WingedGreaves").counter <= 0 || n.getParents().size() <= 0) continue;
                        limitedFloor.append("Winged ").append(Map.nodeType(n)).append(" Floor:").append(i + 1).append(" X: ").append(n.x).append("\r\n");
                    }
                    limitedFloor.append("\r\n");
                    prev.clear();
                    prev.addAll(current);
                    current.clear();
                    limitedMap.insert(0, limitedFloor);
                }
                s.append((CharSequence)limitedMap);
            }
            return s.toString();
        }
        return "";
    }

    public static void downfallMapChoice(int choice) {
        MapRoomNode currMapNode = AbstractDungeon.getCurrMapNode();
        if (currMapNode.y == 0) {
            if (choice == 0) {
                DungeonMapPatch.doBossHover = true;
                return;
            }
            throw new IndexOutOfBoundsException("Only a boss node can be chosen here.");
        }
        ArrayList<MapRoomNode> nodeChoices = Map.getMapScreenNodeChoices();
        MapRoomNodeHoverPatch.hoverNode = nodeChoices.get(choice);
        MapRoomNodeHoverPatch.doHover = true;
        AbstractDungeon.dungeonMapScreen.clicked = true;
    }

    public static ArrayList<MapRoomNode> getMapScreenNodeChoices() {
        ArrayList<MapRoomNode> choices = new ArrayList<MapRoomNode>();
        MapRoomNode currMapNode = AbstractDungeon.getCurrMapNode();
        ArrayList map = AbstractDungeon.map;
        if (!AbstractDungeon.firstRoomChosen) {
            for (MapRoomNode node : (ArrayList)map.get(14)) {
                if (!node.hasEdges()) continue;
                choices.add(node);
            }
        } else {
            for (ArrayList rows : map) {
                for (MapRoomNode node : rows) {
                    if (!node.hasEdges()) continue;
                    boolean normalConnection = currMapNode.isConnectedTo(node);
                    boolean wingedConnection = currMapNode.wingedIsConnectedTo(node);
                    if (!normalConnection && !wingedConnection) continue;
                    choices.add(node);
                }
            }
        }
        return choices;
    }

    public static String nodeType(MapRoomNode n) {
        if (n.getRoom() == null) {
            return "null";
        }
        if (n.getRoom() instanceof MonsterRoomElite) {
            if (n.hasEmeraldKey) {
                return "Emerald Key ";
            }
            return "Elite ";
        }
        if (TextTheSpire.replayTheSpire && n == BonfirePatches.bonfireNode) {
            return "Bonfire ";
        }
        String s = n.getRoom().getClass().getSimpleName();
        if (s.equals("EventRoom")) {
            return "Unknown ";
        }
        if (s.substring(s.length() - 4).equals("Room")) {
            return s.substring(0, s.length() - 4) + " ";
        }
        return s + " ";
    }
}

