/*
 * Decompiled with CFR 0.152.
 */
package textTheSpire;

import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.blights.AbstractBlight;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import communicationmod.CommandExecutor;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import textTheSpire.AbstractWindow;
import textTheSpire.Window;

public class Relic
extends AbstractWindow {
    public Relic(Display display) {
        this.isVisible = true;
        this.window = new Window(display, "Relic", 300, 300);
    }

    @Override
    public String getText() {
        if (this.window.shell.isDisposed()) {
            Display.getDefault().dispose();
            Gdx.app.exit();
        }
        StringBuilder s = new StringBuilder();
        s.append("\r\n");
        if (CardCrawlGame.dungeon == null || !CommandExecutor.isInDungeon() || !CardCrawlGame.isInARun()) {
            return "";
        }
        ArrayList relics = AbstractDungeon.player.relics;
        for (int i = relics.size() - 1; i >= 0; --i) {
            AbstractRelic r = (AbstractRelic)relics.get(i);
            if (r.counter >= 0) {
                s.append(i).append(":").append(r.name).append(" ").append(r.counter).append("\r\n");
                continue;
            }
            s.append(i).append(":").append(r.name).append("\r\n");
        }
        ArrayList blights = AbstractDungeon.player.blights;
        if (blights.size() > 0) {
            s.append("Blights\r\n");
            for (int i = blights.size() - 1; i >= 0; --i) {
                AbstractBlight r = (AbstractBlight)blights.get(i);
                if (r.counter >= 0) {
                    s.append(i + relics.size()).append(":").append(r.name).append(" ").append(r.counter).append("\r\n");
                    continue;
                }
                s.append(i + relics.size()).append(":").append(r.name).append("\r\n");
            }
        }
        return s.toString();
    }
}

