/*
 * Decompiled with CFR 0.152.
 */
package textTheSpire;

import basemod.ReflectionHacks;
import charbosses.bosses.AbstractCharBoss;
import charbosses.stances.AbstractEnemyStance;
import charbosses.ui.EnemyEnergyPanel;
import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.orbs.AbstractOrb;
import com.megacrit.cardcrawl.orbs.Dark;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.RunicDome;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import communicationmod.CommandExecutor;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import textTheSpire.AbstractWindow;
import textTheSpire.TextTheSpire;
import textTheSpire.Window;

public class Monster
extends AbstractWindow {
    public int totalDmg = 0;

    public Monster(Display display) {
        this.isVisible = true;
        this.window = new Window(display, "Monster", 400, 600);
    }

    @Override
    public String getText() {
        if (this.window.shell.isDisposed()) {
            Display.getDefault().dispose();
            Gdx.app.exit();
        }
        StringBuilder s = new StringBuilder();
        if (CardCrawlGame.dungeon == null || !CommandExecutor.isInDungeon() || !CardCrawlGame.isInARun()) {
            return "";
        }
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            int count = 0;
            int totalAlive = 0;
            this.totalDmg = 0;
            for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                if (m.currentHealth > 0) {
                    ++totalAlive;
                    s.append(count).append(": ").append(m.name).append("\r\n");
                    s.append("Block: ").append(m.currentBlock).append("\r\n");
                    s.append("HP: ").append(m.currentHealth).append("/").append(m.maxHealth).append("\r\n");
                    if (!(this.runicDome() || TextTheSpire.downfall && m instanceof AbstractCharBoss)) {
                        s.append(this.monsterIntent(m));
                    }
                    int powCount = 0;
                    ArrayList p = m.powers;
                    if (p.size() > 0) {
                        s.append("Powers:\r\n");
                        for (Object ap : p) {
                            s.append(powCount).append(": ").append(((AbstractPower)ap).name).append(" ").append(((AbstractPower)ap).amount).append("\r\n");
                            ++powCount;
                        }
                    }
                    if (TextTheSpire.downfall && m instanceof AbstractCharBoss) {
                        s.append("Hand:\r\n");
                        int hand_count = 0;
                        for (AbstractCard c : ((AbstractCharBoss)m).hand.group) {
                            s.append(hand_count).append(": ").append(c.name).append("\r\n");
                            ++hand_count;
                        }
                        s.append("Energy: ").append(EnemyEnergyPanel.totalCount).append("\r\n");
                        if (((AbstractCharBoss)m).orbs.size() > 0) {
                            int orb_count = 0;
                            s.append("Orbs:\r\n");
                            for (AbstractOrb o : ((AbstractCharBoss)m).orbs) {
                                if (o instanceof Dark) {
                                    s.append(orb_count).append(": ").append(count).append("Dark ").append(o.evokeAmount).append("\r\n");
                                    continue;
                                }
                                s.append(orb_count).append(": ").append(o.name).append("\r\n");
                            }
                        }
                        if (((AbstractCharBoss)m).stance instanceof AbstractEnemyStance) {
                            s.append("Stance: ").append(((AbstractEnemyStance)((AbstractCharBoss)m).stance).ID).append("\r\n");
                        }
                        s.append("Relics:\r\n");
                        int relic_count = 0;
                        for (AbstractRelic r : ((AbstractCharBoss)m).relics) {
                            if (r.counter >= 0) {
                                s.append(relic_count).append(": ").append(r.name).append(" ").append(r.counter).append("\r\n");
                            } else {
                                s.append(relic_count).append(": ").append(r.name).append("\r\n");
                            }
                            ++relic_count;
                        }
                        s.append("b [h/o/r] [index]\r\n");
                    }
                }
                ++count;
            }
            if (!TextTheSpire.downfall || !(AbstractDungeon.getCurrRoom().monsters.monsters.get(0) instanceof AbstractCharBoss)) {
                s.insert(0, "\r\nCount: " + totalAlive + "\r\nIncoming: " + this.totalDmg + "\r\n");
            }
            return s.toString();
        }
        return "";
    }

    public boolean runicDome() {
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            if (!(r instanceof RunicDome)) continue;
            return true;
        }
        return false;
    }

    public String monsterIntent(AbstractMonster m) {
        AbstractMonster.Intent i = m.intent;
        if (i == AbstractMonster.Intent.ATTACK) {
            int multi = this.getMulti(m);
            if (multi > 1) {
                this.totalDmg += m.getIntentDmg() * multi;
                return "Intent: Attack " + m.getIntentDmg() + " x " + multi + "\r\n";
            }
            this.totalDmg += m.getIntentDmg();
            return "Intent: Attack " + m.getIntentDmg() + "\r\n";
        }
        if (i == AbstractMonster.Intent.ATTACK_BUFF) {
            int multi = this.getMulti(m);
            if (multi > 1) {
                this.totalDmg += m.getIntentDmg() * multi;
                return "Intent: Attack/Buff " + m.getIntentDmg() + " x " + multi + "\r\n";
            }
            this.totalDmg += m.getIntentDmg();
            return "Intent: Attack/Buff " + m.getIntentDmg() + "\r\n";
        }
        if (i == AbstractMonster.Intent.ATTACK_DEFEND) {
            int multi = this.getMulti(m);
            if (multi > 1) {
                this.totalDmg += m.getIntentDmg() * multi;
                return "Intent: Attack/Defend " + m.getIntentDmg() + " x " + multi + "\r\n";
            }
            this.totalDmg += m.getIntentDmg();
            return "Intent: Attack/Defend " + m.getIntentDmg() + "\r\n";
        }
        if (i == AbstractMonster.Intent.ATTACK_DEBUFF) {
            int multi = this.getMulti(m);
            if (multi > 1) {
                this.totalDmg += m.getIntentDmg() * multi;
                return "Intent: Attack/Debuff " + m.getIntentDmg() + " x " + multi + "\r\n";
            }
            this.totalDmg += m.getIntentDmg();
            return "Intent: Attack/Debuff " + m.getIntentDmg() + "\r\n";
        }
        if (i == AbstractMonster.Intent.BUFF) {
            return "Intent: Buff\r\n";
        }
        if (i == AbstractMonster.Intent.DEBUFF) {
            return "Intent: Debuff\r\n";
        }
        if (i == AbstractMonster.Intent.STRONG_DEBUFF) {
            return "Intent: Strong Debuff\r\n";
        }
        if (i == AbstractMonster.Intent.DEFEND) {
            return "Intent: Defend\r\n";
        }
        if (i == AbstractMonster.Intent.DEFEND_DEBUFF) {
            return "Intent: Defend/Debuff\r\n";
        }
        if (i == AbstractMonster.Intent.DEFEND_BUFF) {
            return "Intent: Defend/Buff\r\n";
        }
        if (i == AbstractMonster.Intent.ESCAPE) {
            return "Intent: Escape\r\n";
        }
        if (i == AbstractMonster.Intent.MAGIC) {
            return "Intent: MAGIC\r\n";
        }
        if (i == AbstractMonster.Intent.NONE) {
            return "Intent: NONE\r\n";
        }
        if (i == AbstractMonster.Intent.SLEEP) {
            return "Intent: Sleep\r\n";
        }
        if (i == AbstractMonster.Intent.STUN) {
            return "Intent: Stun\r\n";
        }
        if (i == AbstractMonster.Intent.UNKNOWN) {
            return "Intent: Unknown\r\n";
        }
        return "Intent: Loading\r\n";
    }

    public int getMulti(AbstractMonster m) {
        return (Integer)ReflectionHacks.getPrivate((Object)m, AbstractMonster.class, (String)"intentMultiAmt");
    }
}

