/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Curve;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.FileReference;
import com.brashmonkey.spriter.Point;
import java.util.ArrayList;
import java.util.List;

public class Timeline {
    public final List<Key> keys;
    public final int id;
    public final String name;
    public final Entity.ObjectInfo objectInfo;

    Timeline(int id, String name, Entity.ObjectInfo objectInfo) {
        this(id, name, objectInfo, new ArrayList<Key>());
    }

    Timeline(int id, String name, Entity.ObjectInfo objectInfo, List<Key> keys) {
        this.id = id;
        this.name = name;
        this.objectInfo = objectInfo;
        this.keys = keys;
    }

    void addKey(Key key) {
        this.keys.add(key);
    }

    public Key getKey(int index) {
        return this.keys.get(index);
    }

    public String toString() {
        String toReturn = this.getClass().getSimpleName() + "|[id:" + this.id + ", name: " + this.name + ", object_info: " + this.objectInfo;
        for (Key key : this.keys) {
            toReturn = toReturn + "\n" + key;
        }
        toReturn = toReturn + "]";
        return toReturn;
    }

    public static class Key {
        public final int id;
        public final int spin;
        public int time;
        public final Curve curve;
        public boolean active;
        private Object object;

        public Key(int id, int time, int spin, Curve curve) {
            this.id = id;
            this.time = time;
            this.spin = spin;
            this.curve = curve;
        }

        public Key(int id, int time, int spin) {
            this(id, time, 1, new Curve());
        }

        public Key(int id, int time) {
            this(id, time, 1);
        }

        public Key(int id) {
            this(id, 0);
        }

        public void setObject(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object can not be null!");
            }
            this.object = object;
        }

        public Object object() {
            return this.object;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "|[id: " + this.id + ", time: " + this.time + ", spin: " + this.spin + "\ncurve: " + this.curve + "\nobject:" + this.object + "]";
        }

        public static class Object
        extends Bone {
            public float alpha;
            public final FileReference ref;

            public Object(Point position, Point scale, Point pivot, float angle, float alpha, FileReference ref) {
                super(position, scale, pivot, angle);
                this.alpha = alpha;
                this.ref = ref;
            }

            public Object(Point position) {
                this(position, new Point(1.0f, 1.0f), new Point(0.0f, 1.0f), 0.0f, 1.0f, new FileReference(-1, -1));
            }

            public Object(Object object) {
                this(object.position.copy(), object.scale.copy(), object.pivot.copy(), object.angle, object.alpha, object.ref);
            }

            public Object() {
                this(new Point());
            }

            public void set(Object object) {
                this.set(object.position, object.angle, object.scale, object.pivot, object.alpha, object.ref);
            }

            public void set(float x, float y, float angle, float scaleX, float scaleY, float pivotX, float pivotY, float alpha, int folder, int file) {
                super.set(x, y, angle, scaleX, scaleY, pivotX, pivotY);
                this.alpha = alpha;
                this.ref.folder = folder;
                this.ref.file = file;
            }

            public void set(Point position, float angle, Point scale, Point pivot, float alpha, FileReference fileRef) {
                this.set(position.x, position.y, angle, scale.x, scale.y, pivot.x, pivot.y, alpha, fileRef.folder, fileRef.file);
            }

            @Override
            public String toString() {
                return super.toString() + ", pivot: " + this.pivot + ", alpha: " + this.alpha + ", reference: " + this.ref;
            }
        }

        public static class Bone {
            public final Point position;
            public final Point scale;
            public final Point pivot;
            public float angle;

            public Bone(Point position, Point scale, Point pivot, float angle) {
                this.position = new Point(position);
                this.scale = new Point(scale);
                this.angle = angle;
                this.pivot = new Point(pivot);
            }

            public Bone(Bone bone) {
                this(bone.position, bone.scale, bone.pivot, bone.angle);
            }

            public Bone(Point position) {
                this(position, new Point(1.0f, 1.0f), new Point(0.0f, 1.0f), 0.0f);
            }

            public Bone() {
                this(new Point());
            }

            public boolean isBone() {
                return !(this instanceof Object);
            }

            public void set(Bone bone) {
                this.set(bone.position, bone.angle, bone.scale, bone.pivot);
            }

            public void set(float x, float y, float angle, float scaleX, float scaleY, float pivotX, float pivotY) {
                this.angle = angle;
                this.position.set(x, y);
                this.scale.set(scaleX, scaleY);
                this.pivot.set(pivotX, pivotY);
            }

            public void set(Point position, float angle, Point scale, Point pivot) {
                this.set(position.x, position.y, angle, scale.x, scale.y, pivot.x, pivot.y);
            }

            public void unmap(Bone parent) {
                this.angle *= Math.signum(parent.scale.x) * Math.signum(parent.scale.y);
                this.angle += parent.angle;
                this.scale.scale(parent.scale);
                this.position.scale(parent.scale);
                this.position.rotate(parent.angle);
                this.position.translate(parent.position);
            }

            public void map(Bone parent) {
                this.position.translate(-parent.position.x, -parent.position.y);
                this.position.rotate(-parent.angle);
                this.position.scale(1.0f / parent.scale.x, 1.0f / parent.scale.y);
                this.scale.scale(1.0f / parent.scale.x, 1.0f / parent.scale.y);
                this.angle -= parent.angle;
                this.angle *= Math.signum(parent.scale.x) * Math.signum(parent.scale.y);
            }

            public String toString() {
                return this.getClass().getSimpleName() + "|position: " + this.position + ", scale: " + this.scale + ", angle: " + this.angle;
            }
        }
    }
}

