/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Animation;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.Player;
import com.brashmonkey.spriter.SpriterException;
import com.brashmonkey.spriter.TweenedAnimation;

public class PlayerTweener
extends Player {
    private TweenedAnimation anim;
    private Player player1;
    private Player player2;
    public boolean updatePlayers = true;
    public String baseBoneName = null;

    public PlayerTweener(Player player1, Player player2) {
        super(player1.getEntity());
        this.setPlayers(player1, player2);
    }

    public PlayerTweener(Entity entity) {
        this(new Player(entity), new Player(entity));
    }

    @Override
    public void update() {
        if (this.updatePlayers) {
            this.player1.update();
            this.player2.update();
        }
        this.anim.setAnimations(this.player1.animation, this.player2.animation);
        super.update();
        if (this.baseBoneName != null) {
            int index;
            int n = index = this.anim.onFirstMainLine() ? this.player1.getBoneIndex(this.baseBoneName) : this.player2.getBoneIndex(this.baseBoneName);
            if (index == -1) {
                throw new SpriterException("A bone with name \"" + this.baseBoneName + "\" does no exist!");
            }
            this.anim.base = this.anim.getCurrentKey().getBoneRef(index);
            super.update();
        }
    }

    public void setPlayers(Player player1, Player player2) {
        if (player1.entity != player2.entity) {
            throw new SpriterException("player1 and player2 have to hold the same entity!");
        }
        this.player1 = player1;
        this.player2 = player2;
        if (player1.entity == this.entity) {
            return;
        }
        this.anim = new TweenedAnimation(player1.getEntity());
        this.anim.setAnimations(player1.animation, player2.animation);
        super.setEntity(player1.getEntity());
        super.setAnimation(this.anim);
    }

    public Player getFirstPlayer() {
        return this.player1;
    }

    public Player getSecondPlayer() {
        return this.player2;
    }

    public void setWeight(float weight) {
        this.anim.weight = weight;
    }

    public float getWeight() {
        return this.anim.weight;
    }

    public void setBaseAnimation(Animation anim) {
        this.anim.baseAnimation = anim;
    }

    public void setBaseAnimation(int index) {
        this.setBaseAnimation(this.entity.getAnimation(index));
    }

    public void setBaseAnimation(String name) {
        this.setBaseAnimation(this.entity.getAnimation(name));
    }

    public Animation getBaseAnimation() {
        return this.anim.baseAnimation;
    }

    @Override
    public void setAnimation(Animation anim) {
    }

    @Override
    public void setEntity(Entity entity) {
    }
}

