/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Box;
import com.brashmonkey.spriter.Dimension;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.Loader;
import com.brashmonkey.spriter.Player;
import com.brashmonkey.spriter.Rectangle;
import com.brashmonkey.spriter.SpriterException;
import com.brashmonkey.spriter.Timeline;
import java.util.Iterator;

public abstract class Drawer<R> {
    public float pointRadius = 5.0f;
    protected Loader<R> loader;

    public Drawer(Loader<R> loader) {
        this.loader = loader;
    }

    public void setLoader(Loader<R> loader) {
        if (loader == null) {
            throw new SpriterException("The loader instance can not be null!");
        }
        this.loader = loader;
    }

    public void drawBones(Player player) {
        this.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        Iterator<Timeline.Key.Bone> it = player.boneIterator();
        while (it.hasNext()) {
            Timeline.Key.Bone bone = it.next();
            Timeline.Key key = player.getKeyFor(bone);
            if (!key.active) continue;
            Entity.ObjectInfo info = player.getObjectInfoFor(bone);
            Dimension size = info.size;
            this.drawBone(bone, size);
        }
    }

    public void drawBone(Timeline.Key.Bone bone, Dimension size) {
        float halfHeight = size.height / 2.0f;
        float xx = bone.position.x + (float)Math.cos(Math.toRadians(bone.angle)) * size.height;
        float yy = bone.position.y + (float)Math.sin(Math.toRadians(bone.angle)) * size.height;
        float x2 = (float)Math.cos(Math.toRadians(bone.angle + 90.0f)) * halfHeight * bone.scale.y;
        float y2 = (float)Math.sin(Math.toRadians(bone.angle + 90.0f)) * halfHeight * bone.scale.y;
        float targetX = bone.position.x + (float)Math.cos(Math.toRadians(bone.angle)) * size.width * bone.scale.x;
        float targetY = bone.position.y + (float)Math.sin(Math.toRadians(bone.angle)) * size.width * bone.scale.x;
        float upperPointX = xx + x2;
        float upperPointY = yy + y2;
        this.line(bone.position.x, bone.position.y, upperPointX, upperPointY);
        this.line(upperPointX, upperPointY, targetX, targetY);
        float lowerPointX = xx - x2;
        float lowerPointY = yy - y2;
        this.line(bone.position.x, bone.position.y, lowerPointX, lowerPointY);
        this.line(lowerPointX, lowerPointY, targetX, targetY);
        this.line(bone.position.x, bone.position.y, targetX, targetY);
    }

    public void drawBoxes(Player player) {
        this.setColor(0.0f, 1.0f, 0.0f, 1.0f);
        this.drawBoneBoxes(player);
        this.drawObjectBoxes(player);
        this.drawPoints(player);
    }

    public void drawBoneBoxes(Player player) {
        this.drawBoneBoxes(player, player.boneIterator());
    }

    public void drawBoneBoxes(Player player, Iterator<Timeline.Key.Bone> it) {
        while (it.hasNext()) {
            Timeline.Key.Bone bone = it.next();
            this.drawBox(player.getBox(bone));
        }
    }

    public void drawObjectBoxes(Player player) {
        this.drawObjectBoxes(player, player.objectIterator());
    }

    public void drawObjectBoxes(Player player, Iterator<Timeline.Key.Object> it) {
        while (it.hasNext()) {
            Timeline.Key.Object bone = it.next();
            this.drawBox(player.getBox(bone));
        }
    }

    public void drawPoints(Player player) {
        this.drawPoints(player, player.objectIterator());
    }

    public void drawPoints(Player player, Iterator<Timeline.Key.Object> it) {
        while (it.hasNext()) {
            Timeline.Key.Object point = it.next();
            if (player.getObjectInfoFor((Timeline.Key.Bone)point).type != Entity.ObjectType.Point) continue;
            float x = point.position.x + (float)(Math.cos(Math.toRadians(point.angle)) * (double)this.pointRadius);
            float y = point.position.y + (float)(Math.sin(Math.toRadians(point.angle)) * (double)this.pointRadius);
            this.circle(point.position.x, point.position.y, this.pointRadius);
            this.line(point.position.x, point.position.y, x, y);
        }
    }

    public void draw(Player player) {
        this.draw(player, player.characterMap);
    }

    public void draw(Player player, Entity.CharacterMap map) {
        this.draw(player.objectIterator(), map);
    }

    public void draw(Iterator<Timeline.Key.Object> it, Entity.CharacterMap map) {
        while (it.hasNext()) {
            Timeline.Key.Object object = it.next();
            if (!object.ref.hasFile()) continue;
            if (map != null) {
                object.ref.set(map.get(object.ref));
            }
            this.draw(object);
        }
    }

    public void drawBox(Box box) {
        this.line(box.points[0].x, box.points[0].y, box.points[1].x, box.points[1].y);
        this.line(box.points[1].x, box.points[1].y, box.points[3].x, box.points[3].y);
        this.line(box.points[3].x, box.points[3].y, box.points[2].x, box.points[2].y);
        this.line(box.points[2].x, box.points[2].y, box.points[0].x, box.points[0].y);
    }

    public void drawRectangle(Rectangle rect) {
        this.rectangle(rect.left, rect.bottom, rect.size.width, rect.size.height);
    }

    public abstract void setColor(float var1, float var2, float var3, float var4);

    public abstract void line(float var1, float var2, float var3, float var4);

    public abstract void rectangle(float var1, float var2, float var3, float var4);

    public abstract void circle(float var1, float var2, float var3);

    public abstract void draw(Timeline.Key.Object var1);
}

