/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Calculator;
import com.brashmonkey.spriter.Interpolator;
import com.brashmonkey.spriter.Point;
import com.brashmonkey.spriter.SpriterException;

public class Curve {
    private Type type;
    public Curve subCurve;
    public final Constraints constraints = new Constraints(0.0f, 0.0f, 0.0f, 0.0f);
    private float lastCubicSolution = 0.0f;

    public static Type getType(String name) {
        if (name.equals("instant")) {
            return Type.Instant;
        }
        if (name.equals("quadratic")) {
            return Type.Quadratic;
        }
        if (name.equals("cubic")) {
            return Type.Cubic;
        }
        if (name.equals("quartic")) {
            return Type.Quartic;
        }
        if (name.equals("quintic")) {
            return Type.Quintic;
        }
        if (name.equals("bezier")) {
            return Type.Bezier;
        }
        return Type.Linear;
    }

    public Curve() {
        this(Type.Linear);
    }

    public Curve(Type type) {
        this(type, null);
    }

    public Curve(Type type, Curve subCurve) {
        this.setType(type);
        this.subCurve = subCurve;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new SpriterException("The type of a curve cannot be null!");
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public float tween(float a, float b, float t) {
        t = this.tweenSub(0.0f, 1.0f, t);
        switch (this.type) {
            case Instant: {
                return a;
            }
            case Linear: {
                return Interpolator.linear(a, b, t);
            }
            case Quadratic: {
                return Interpolator.quadratic(a, Interpolator.linear(a, b, this.constraints.c1), b, t);
            }
            case Cubic: {
                return Interpolator.cubic(a, Interpolator.linear(a, b, this.constraints.c1), Interpolator.linear(a, b, this.constraints.c2), b, t);
            }
            case Quartic: {
                return Interpolator.quartic(a, Interpolator.linear(a, b, this.constraints.c1), Interpolator.linear(a, b, this.constraints.c2), Interpolator.linear(a, b, this.constraints.c3), b, t);
            }
            case Quintic: {
                return Interpolator.quintic(a, Interpolator.linear(a, b, this.constraints.c1), Interpolator.linear(a, b, this.constraints.c2), Interpolator.linear(a, b, this.constraints.c3), Interpolator.linear(a, b, this.constraints.c4), b, t);
            }
            case Bezier: {
                Float cubicSolution = Calculator.solveCubic(3.0f * (this.constraints.c1 - this.constraints.c3) + 1.0f, 3.0f * (this.constraints.c3 - 2.0f * this.constraints.c1), 3.0f * this.constraints.c1, -t);
                if (cubicSolution == null) {
                    cubicSolution = Float.valueOf(this.lastCubicSolution);
                } else {
                    this.lastCubicSolution = cubicSolution.floatValue();
                }
                return Interpolator.linear(a, b, Interpolator.bezier(cubicSolution.floatValue(), 0.0f, this.constraints.c2, this.constraints.c4, 1.0f));
            }
        }
        return Interpolator.linear(a, b, t);
    }

    public void tweenPoint(Point a, Point b, float t, Point target) {
        target.set(this.tween(a.x, b.x, t), this.tween(a.y, b.y, t));
    }

    private float tweenSub(float a, float b, float t) {
        if (this.subCurve != null) {
            return this.subCurve.tween(a, b, t);
        }
        return t;
    }

    public float tweenAngle(float a, float b, float t, int spin) {
        if (spin > 0) {
            if (b - a < 0.0f) {
                b += 360.0f;
            }
        } else if (spin < 0) {
            if (b - a > 0.0f) {
                b -= 360.0f;
            }
        } else {
            return a;
        }
        return this.tween(a, b, t);
    }

    public float tweenAngle(float a, float b, float t) {
        t = this.tweenSub(0.0f, 1.0f, t);
        switch (this.type) {
            case Instant: {
                return a;
            }
            case Linear: {
                return Interpolator.linearAngle(a, b, t);
            }
            case Quadratic: {
                return Interpolator.quadraticAngle(a, Interpolator.linearAngle(a, b, this.constraints.c1), b, t);
            }
            case Cubic: {
                return Interpolator.cubicAngle(a, Interpolator.linearAngle(a, b, this.constraints.c1), Interpolator.linearAngle(a, b, this.constraints.c2), b, t);
            }
            case Quartic: {
                return Interpolator.quarticAngle(a, Interpolator.linearAngle(a, b, this.constraints.c1), Interpolator.linearAngle(a, b, this.constraints.c2), Interpolator.linearAngle(a, b, this.constraints.c3), b, t);
            }
            case Quintic: {
                return Interpolator.quinticAngle(a, Interpolator.linearAngle(a, b, this.constraints.c1), Interpolator.linearAngle(a, b, this.constraints.c2), Interpolator.linearAngle(a, b, this.constraints.c3), Interpolator.linearAngle(a, b, this.constraints.c4), b, t);
            }
            case Bezier: {
                Float cubicSolution = Calculator.solveCubic(3.0f * (this.constraints.c1 - this.constraints.c3) + 1.0f, 3.0f * (this.constraints.c3 - 2.0f * this.constraints.c1), 3.0f * this.constraints.c1, -t);
                if (cubicSolution == null) {
                    cubicSolution = Float.valueOf(this.lastCubicSolution);
                } else {
                    this.lastCubicSolution = cubicSolution.floatValue();
                }
                return Interpolator.linearAngle(a, b, Interpolator.bezier(cubicSolution.floatValue(), 0.0f, this.constraints.c2, this.constraints.c4, 1.0f));
            }
        }
        return Interpolator.linearAngle(a, b, t);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "|[" + (Object)((Object)this.type) + ":" + this.constraints + ", subCurve: " + this.subCurve + "]";
    }

    public static class Constraints {
        public float c1;
        public float c2;
        public float c3;
        public float c4;

        public Constraints(float c1, float c2, float c3, float c4) {
            this.set(c1, c2, c3, c4);
        }

        public void set(float c1, float c2, float c3, float c4) {
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "| [c1:" + this.c1 + ", c2:" + this.c2 + ", c3:" + this.c3 + ", c4:" + this.c4 + "]";
        }
    }

    public static enum Type {
        Instant,
        Linear,
        Quadratic,
        Cubic,
        Quartic,
        Quintic,
        Bezier;

    }
}

