/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

public class Calculator {
    public static final float PI = (float)Math.PI;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;

    public static float angleDifference(float a, float b) {
        return ((a - b) % 360.0f + 540.0f) % 360.0f - 180.0f;
    }

    public static float angleBetween(float x1, float y1, float x2, float y2) {
        return (float)Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
    }

    public static float distanceBetween(float x1, float y1, float x2, float y2) {
        float xDiff = x2 - x1;
        float yDiff = y2 - y1;
        return Calculator.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public static Float solveCubic(float a, float b, float c, float d) {
        if (a == 0.0f) {
            return Calculator.solveQuadratic(b, c, d);
        }
        if (d == 0.0f) {
            return Float.valueOf(0.0f);
        }
        float squaredB = Calculator.squared(b /= a);
        float q = (3.0f * (c /= a) - squaredB) / 9.0f;
        float r = (-27.0f * (d /= a) + b * (9.0f * c - 2.0f * squaredB)) / 54.0f;
        float disc = Calculator.cubed(q) + Calculator.squared(r);
        float term1 = b / 3.0f;
        if (disc > 0.0f) {
            float s = r + Calculator.sqrt(disc);
            s = s < 0.0f ? -Calculator.cubicRoot(-s) : Calculator.cubicRoot(s);
            float t = r - Calculator.sqrt(disc);
            float result = -term1 + s + (t = t < 0.0f ? -Calculator.cubicRoot(-t) : Calculator.cubicRoot(t));
            if (result >= 0.0f && result <= 1.0f) {
                return Float.valueOf(result);
            }
        } else if (disc == 0.0f) {
            float r13 = r < 0.0f ? -Calculator.cubicRoot(-r) : Calculator.cubicRoot(r);
            float result = -term1 + 2.0f * r13;
            if (result >= 0.0f && result <= 1.0f) {
                return Float.valueOf(result);
            }
            result = -(r13 + term1);
            if (result >= 0.0f && result <= 1.0f) {
                return Float.valueOf(result);
            }
        } else {
            q = -q;
            float dum1 = q * q * q;
            dum1 = Calculator.acos(r / Calculator.sqrt(dum1));
            float r13 = 2.0f * Calculator.sqrt(q);
            float result = -term1 + r13 * Calculator.cos(dum1 / 3.0f);
            if (result >= 0.0f && result <= 1.0f) {
                return Float.valueOf(result);
            }
            result = -term1 + r13 * Calculator.cos((dum1 + (float)Math.PI * 2) / 3.0f);
            if (result >= 0.0f && result <= 1.0f) {
                return Float.valueOf(result);
            }
            result = -term1 + r13 * Calculator.cos((dum1 + (float)Math.PI * 4) / 3.0f);
            if (result >= 0.0f && result <= 1.0f) {
                return Float.valueOf(result);
            }
        }
        return null;
    }

    public static Float solveQuadratic(float a, float b, float c) {
        float squaredB = Calculator.squared(b);
        float twoA = 2.0f * a;
        float fourAC = 4.0f * a * c;
        float result = (-b + Calculator.sqrt(squaredB - fourAC)) / twoA;
        if (result >= 0.0f && result <= 1.0f) {
            return Float.valueOf(result);
        }
        result = (-b - Calculator.sqrt(squaredB - fourAC)) / twoA;
        if (result >= 0.0f && result <= 1.0f) {
            return Float.valueOf(result);
        }
        return null;
    }

    public static float squared(float f) {
        return f * f;
    }

    public static float cubed(float f) {
        return f * f * f;
    }

    public static float cubicRoot(float f) {
        return (float)Math.pow(f, 0.3333333432674408);
    }

    public static float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    public static float acos(float x) {
        return (float)Math.acos(x);
    }

    public static final float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static final float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static final float sinDeg(float degrees) {
        return Sin.table[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static final float cosDeg(float degrees) {
        return Sin.table[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int i;
            table = new float[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            }
        }
    }
}

