/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.screens.SingleCardViewPopup;

import basemod.abstracts.CustomCard;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.screens.SingleCardViewPopup;

public class CustomRendering {
    private static void renderHelper(SpriteBatch sb, float x, float y, TextureAtlas.AtlasRegion img) {
        if (img != null) {
            sb.draw((TextureRegion)img, x + img.offsetX - (float)img.originalWidth / 2.0f, y + img.offsetY - (float)img.originalHeight / 2.0f, (float)img.originalWidth / 2.0f - img.offsetX, (float)img.originalHeight / 2.0f - img.offsetY, (float)img.packedWidth, (float)img.packedHeight, Settings.scale, Settings.scale, 0.0f);
        }
    }

    private static void dynamicFrameRenderHelper(SpriteBatch sb, TextureAtlas.AtlasRegion img, float xOffset, float drawScale, float xScale) {
        if (img != null) {
            sb.draw((TextureRegion)img, (float)Settings.WIDTH / 2.0f + img.offsetX - (float)img.originalWidth / 2.0f + xOffset * drawScale, (float)Settings.HEIGHT / 2.0f + img.offsetY - (float)img.originalHeight / 2.0f, (float)img.originalWidth / 2.0f - img.offsetX, (float)img.originalHeight / 2.0f - img.offsetY, (float)img.packedWidth, (float)img.packedHeight, Settings.scale * xScale, Settings.scale, 0.0f);
        }
    }

    @SpirePatch(clz=SingleCardViewPopup.class, method="renderFrame")
    public static class RenderCustomFrame {
        public static SpireReturn<?> Prefix(SingleCardViewPopup __instance, SpriteBatch sb, AbstractCard ___card, float ___drawScale) {
            if (!(___card instanceof CustomCard)) {
                return SpireReturn.Continue();
            }
            CustomCard card = (CustomCard)___card;
            if (card.frameLargeRegion != null) {
                CustomRendering.renderHelper(sb, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, card.frameLargeRegion);
                if (card.frameMiddleLargeRegion != null) {
                    float tWidth = 0.0f;
                    float tOffset = 0.0f;
                    switch (card.type) {
                        case ATTACK: {
                            tWidth = AbstractCard.typeWidthAttack;
                            tOffset = AbstractCard.typeOffsetAttack;
                            break;
                        }
                        case SKILL: {
                            tWidth = AbstractCard.typeWidthSkill;
                            tOffset = AbstractCard.typeOffsetSkill;
                            break;
                        }
                        case POWER: {
                            tWidth = AbstractCard.typeWidthPower;
                            tOffset = AbstractCard.typeOffsetPower;
                            break;
                        }
                        case STATUS: {
                            tWidth = AbstractCard.typeWidthStatus;
                            tOffset = AbstractCard.typeOffsetStatus;
                            break;
                        }
                        case CURSE: {
                            tWidth = AbstractCard.typeWidthCurse;
                            tOffset = AbstractCard.typeOffsetCurse;
                        }
                    }
                    if (tWidth > 1.1f) {
                        CustomRendering.dynamicFrameRenderHelper(sb, ImageMaster.CARD_COMMON_FRAME_MID, 0.0f, ___drawScale, tWidth);
                        CustomRendering.dynamicFrameRenderHelper(sb, ImageMaster.CARD_COMMON_FRAME_LEFT, -tOffset, ___drawScale, 1.0f);
                        CustomRendering.dynamicFrameRenderHelper(sb, ImageMaster.CARD_COMMON_FRAME_RIGHT, tOffset, ___drawScale, 1.0f);
                    }
                }
                return SpireReturn.Return(null);
            }
            return SpireReturn.Continue();
        }
    }

    @SpirePatch(clz=SingleCardViewPopup.class, method="renderCardBanner")
    public static class RenderBannerSwitch {
        public static SpireReturn<?> Prefix(SingleCardViewPopup __instance, SpriteBatch sb, AbstractCard ___card, float ___drawScale) {
            if (!(___card instanceof CustomCard)) {
                return SpireReturn.Continue();
            }
            TextureAtlas.AtlasRegion region = ((CustomCard)___card).getBannerLargeRegion();
            if (region == null) {
                return SpireReturn.Continue();
            }
            CustomRendering.renderHelper(sb, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, region);
            return SpireReturn.Return(null);
        }
    }
}

