/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.screens.SingleCardViewPopup;

import basemod.BaseMod;
import basemod.abstracts.CustomCard;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.screens.SingleCardViewPopup;
import java.lang.reflect.Field;
import javassist.CannotCompileException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;

public class BackgroundFix {

    @SpirePatch(clz=SingleCardViewPopup.class, method="renderCost")
    public static class EnergyOrbTexture {
        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(FieldAccess f) throws CannotCompileException {
                    if (f.getFieldName().equals("CARD_GRAY_ORB_L")) {
                        f.replace("$_ = " + EnergyOrbTexture.class.getName() + ".getEnergyOrb(card, $proceed($$));");
                    }
                }
            };
        }

        public static TextureAtlas.AtlasRegion getEnergyOrb(AbstractCard card, TextureAtlas.AtlasRegion orb) {
            if (card.color == AbstractCard.CardColor.COLORLESS) {
                return orb;
            }
            Texture texture = null;
            if (card instanceof CustomCard) {
                texture = ((CustomCard)card).getOrbLargeTexture();
            }
            if (texture == null && (texture = BaseMod.getEnergyOrbPortraitTexture(card.color)) == null) {
                texture = ImageMaster.loadImage((String)BaseMod.getEnergyOrbPortrait(card.color));
                BaseMod.saveEnergyOrbPortraitTexture(card.color, texture);
            }
            if (texture == null) {
                return orb;
            }
            return new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
        }
    }

    @SpirePatch(clz=SingleCardViewPopup.class, method="renderCardBack")
    public static class BackgroundTexture {
        public static void Prefix(Object __obj_instance, Object sbObject) {
            try {
                SingleCardViewPopup popup = (SingleCardViewPopup)__obj_instance;
                SpriteBatch sb = (SpriteBatch)sbObject;
                Field cardField = popup.getClass().getDeclaredField("card");
                cardField.setAccessible(true);
                AbstractCard card = (AbstractCard)cardField.get(popup);
                AbstractCard.CardColor color = card.color;
                if (!BaseMod.isBaseGameCardColor(color)) {
                    switch (card.type) {
                        case ATTACK: {
                            Texture bgTexture = null;
                            if (card instanceof CustomCard) {
                                bgTexture = ((CustomCard)card).getBackgroundLargeTexture();
                            }
                            if (bgTexture == null && (bgTexture = BaseMod.getAttackBgPortraitTexture(color)) == null) {
                                bgTexture = ImageMaster.loadImage((String)BaseMod.getAttackBgPortrait(color));
                                BaseMod.saveAttackBgPortraitTexture(color, bgTexture);
                            }
                            sb.draw(bgTexture, (float)Settings.WIDTH / 2.0f - 512.0f, (float)Settings.HEIGHT / 2.0f - 512.0f, 512.0f, 512.0f, 1024.0f, 1024.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1024, 1024, false, false);
                            break;
                        }
                        case POWER: {
                            Texture bgTexture = null;
                            if (card instanceof CustomCard) {
                                bgTexture = ((CustomCard)card).getBackgroundLargeTexture();
                            }
                            if (bgTexture == null && (bgTexture = BaseMod.getPowerBgPortraitTexture(color)) == null) {
                                bgTexture = ImageMaster.loadImage((String)BaseMod.getPowerBgPortrait(color));
                                BaseMod.savePowerBgPortraitTexture(color, bgTexture);
                            }
                            sb.draw(bgTexture, (float)Settings.WIDTH / 2.0f - 512.0f, (float)Settings.HEIGHT / 2.0f - 512.0f, 512.0f, 512.0f, 1024.0f, 1024.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1024, 1024, false, false);
                            break;
                        }
                        default: {
                            Texture bgTexture = null;
                            if (card instanceof CustomCard) {
                                bgTexture = ((CustomCard)card).getBackgroundLargeTexture();
                            }
                            if (bgTexture == null && (bgTexture = BaseMod.getSkillBgPortraitTexture(color)) == null) {
                                bgTexture = ImageMaster.loadImage((String)BaseMod.getSkillBgPortrait(color));
                                BaseMod.saveSkillBgPortraitTexture(color, bgTexture);
                            }
                            sb.draw(bgTexture, (float)Settings.WIDTH / 2.0f - 512.0f, (float)Settings.HEIGHT / 2.0f - 512.0f, 512.0f, 512.0f, 1024.0f, 1024.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1024, 1024, false, false);
                        }
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }
}

