/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.screens.CombatRewardScreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.screens.CombatRewardScreen;
import com.megacrit.cardcrawl.screens.mainMenu.ScrollBar;
import com.megacrit.cardcrawl.screens.mainMenu.ScrollBarListener;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.RewardGlowEffect;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

public class RewardsScrolling {

    @SpirePatch(clz=CombatRewardScreen.class, method="rewardViewUpdate")
    public static class ScrollUpdate {
        public static void Postfix(CombatRewardScreen __instance) {
            if (__instance.rewards.size() < 6) {
                Fields.scrollTarget = 0.0f;
                Fields.scrollPosition = 0.0f;
                __instance.positionRewards();
                return;
            }
            if (Fields.scrollBar.update()) {
                return;
            }
            int y = InputHelper.mY;
            if (!Fields.grabbedScreen) {
                if (InputHelper.scrolledDown) {
                    Fields.scrollTarget = Fields.scrollTarget + Settings.SCROLL_SPEED;
                } else if (InputHelper.scrolledUp) {
                    Fields.scrollTarget = Fields.scrollTarget - Settings.SCROLL_SPEED;
                }
                if (InputHelper.justClickedLeft) {
                    Fields.grabbedScreen = true;
                    Fields.grabStartY = (float)y - Fields.scrollTarget;
                }
            } else if (InputHelper.isMouseDown) {
                Fields.scrollTarget = (float)y - Fields.grabStartY;
            } else {
                Fields.grabbedScreen = false;
            }
            float prev_scrollPosition = Fields.scrollTarget;
            Fields.scrollPosition = MathHelper.scrollSnapLerpSpeed((float)Fields.scrollPosition, (float)Fields.scrollTarget);
            if (Fields.scrollTarget < 0.0f) {
                Fields.scrollTarget = 0.0f;
            }
            Fields.scrollUpperBound = (float)(__instance.rewards.size() - 5) * 100.0f * Settings.scale;
            if (Fields.scrollTarget > Fields.scrollUpperBound) {
                Fields.scrollTarget = Fields.scrollUpperBound;
            }
            if (Fields.scrollPosition != prev_scrollPosition) {
                __instance.positionRewards();
            }
            ScrollUpdate.updateBarPosition();
        }

        private static void updateBarPosition() {
            float percent = MathHelper.percentFromValueBetween((float)Fields.scrollLowerBound, (float)Fields.scrollUpperBound, (float)Fields.scrollPosition);
            Fields.scrollBar.parentScrolledToPercent(percent);
        }

        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals(RewardItem.class.getName()) && m.getMethodName().equals("update")) {
                        m.replace("if (" + ScrollUpdate.class.getName() + ".DoUpdate($0)) {$_ = $proceed($$);}");
                    }
                }
            };
        }

        public static boolean DoUpdate(RewardItem reward) {
            boolean ret = false;
            float upperBounds = (float)Settings.HEIGHT / 2.0f + 204.0f * Settings.scale;
            float lowerBounds = (float)Settings.HEIGHT / 2.0f + -336.0f * Settings.scale;
            if (reward.y < upperBounds && reward.y > lowerBounds) {
                ret = true;
            }
            if (!ret) {
                reward.hb.hovered = false;
                reward.hb.justHovered = false;
                reward.hb.clicked = false;
                reward.hb.clickStarted = false;
                if (reward.flashTimer > 0.0f) {
                    reward.flashTimer -= Gdx.graphics.getDeltaTime();
                    if (reward.flashTimer < 0.0f) {
                        reward.flashTimer = 0.0f;
                    }
                }
            }
            try {
                Field f = RewardItem.class.getDeclaredField("effects");
                f.setAccessible(true);
                ArrayList effects = (ArrayList)f.get(reward);
                if (!ret) {
                    if (effects.size() == 0) {
                        effects.add(new RewardGlowEffect(reward.hb.cX, reward.hb.cY));
                    }
                    Iterator it = effects.iterator();
                    while (it.hasNext()) {
                        AbstractGameEffect e = (AbstractGameEffect)it.next();
                        e.update();
                        if (!e.isDone) continue;
                        it.remove();
                    }
                }
                for (AbstractGameEffect e : effects) {
                    if (!(e instanceof RewardGlowEffect)) continue;
                    ScrollUpdate.moveRewardGlowEffect((RewardGlowEffect)e, reward.hb.cX, reward.hb.cY);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            return ret;
        }

        private static void moveRewardGlowEffect(RewardGlowEffect effect, float x, float y) {
            try {
                Field f = RewardGlowEffect.class.getDeclaredField("x");
                f.setAccessible(true);
                f.setFloat(effect, x);
                f = RewardGlowEffect.class.getDeclaredField("y");
                f.setAccessible(true);
                f.setFloat(effect, y);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @SpirePatch(clz=CombatRewardScreen.class, method="positionRewards")
    public static class PositionRewards {
        public static SpireReturn<Void> Prefix(CombatRewardScreen __instance) {
            float baseY = (float)Settings.HEIGHT / 2.0f + 124.0f * Settings.scale;
            float spacingY = 100.0f * Settings.scale;
            for (int i = 0; i < __instance.rewards.size(); ++i) {
                ((RewardItem)__instance.rewards.get(i)).move(baseY - (float)i * spacingY + Fields.scrollPosition);
            }
            if (__instance.rewards.isEmpty()) {
                __instance.hasTakenAll = true;
            }
            return SpireReturn.Return(null);
        }
    }

    @SpirePatch(clz=CombatRewardScreen.class, method="renderItemReward")
    public static class RenderScissor {
        private static OrthographicCamera camera = null;

        @SpireInsertPatch(locator=Locator.class)
        public static void Insert(CombatRewardScreen __instance, SpriteBatch sb) {
            if (camera == null) {
                try {
                    Field f = CardCrawlGame.class.getDeclaredField("camera");
                    f.setAccessible(true);
                    camera = (OrthographicCamera)f.get(Gdx.app.getApplicationListener());
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    return;
                }
            }
            sb.flush();
            Rectangle scissors = new Rectangle();
            Rectangle clipBounds = new Rectangle((float)Settings.WIDTH / 2.0f - 300.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f - 350.0f * Settings.scale, 600.0f * Settings.scale, 600.0f * Settings.scale);
            ScissorStack.calculateScissors((Camera)camera, (Matrix4)sb.getTransformMatrix(), (Rectangle)clipBounds, (Rectangle)scissors);
            ScissorStack.pushScissors((Rectangle)scissors);
        }

        public static void Postfix(CombatRewardScreen __instance, SpriteBatch sb) {
            if (camera != null) {
                sb.flush();
                ScissorStack.popScissors();
            }
            if (__instance.rewards.size() > 5) {
                Fields.scrollBar.render(sb);
            }
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctMethodToPatch) throws CannotCompileException, PatchingException {
                Matcher.FieldAccessMatcher finalMatcher = new Matcher.FieldAccessMatcher(CombatRewardScreen.class, "rewards");
                return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, new ArrayList(), (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatch(clz=CombatRewardScreen.class, method="setupItemReward")
    public static class ResetScrollPosition {
        public static void Prefix(CombatRewardScreen __instance) {
            Fields.scrollPosition = 0.0f;
            Fields.scrollTarget = 0.0f;
            Fields.grabbedScreen = false;
            Fields.grabStartY = 0.0f;
        }
    }

    private static class Fields {
        private static ScrollBar scrollBar = new ScrollBar((ScrollBarListener)new ScrollListener(), (float)Settings.WIDTH / 2.0f + 270.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f - 86.0f * Settings.scale, 500.0f * Settings.scale);
        private static float scrollLowerBound = 0.0f;
        private static float scrollUpperBound = 0.0f;
        private static float scrollPosition = 0.0f;
        private static float scrollTarget = 0.0f;
        private static boolean grabbedScreen = false;
        private static float grabStartY = 0.0f;

        private Fields() {
        }
    }

    private static class ScrollListener
    implements ScrollBarListener {
        private ScrollListener() {
        }

        public void scrolledUsingBar(float v) {
            Fields.scrollPosition = MathHelper.valueFromPercentBetween((float)Fields.scrollLowerBound, (float)Fields.scrollUpperBound, (float)v);
            Fields.scrollTarget = Fields.scrollPosition;
            AbstractDungeon.combatRewardScreen.positionRewards();
            ScrollUpdate.updateBarPosition();
        }
    }
}

