/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.helpers.input.ScrollInputProcessor;

import basemod.BaseMod;
import basemod.interfaces.PreUpdateSubscriber;
import basemod.interfaces.TextReceiver;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePrefixPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.megacrit.cardcrawl.helpers.input.ScrollInputProcessor;
import java.util.ArrayList;

public class TextInput
implements PreUpdateSubscriber {
    public static String text;
    private static final char BACKSPACE = '\b';
    private static final char ENTER_DESKTOP = '\r';
    private static final char ENTER_ANDROID = '\n';
    private static final char TAB = '\t';
    private static int currentCharLimit;
    private static final ArrayList<TextReceiver> receivers;

    @Override
    public void receivePreUpdate() {
        if (receivers.size() > 0 && receivers.get(0).isDone()) {
            TextInput.stopTextReceiver(receivers.get(0));
        }
    }

    public static boolean isTextInputActive() {
        return receivers.size() > 0;
    }

    public static void startTextReceiver(TextReceiver t) {
        receivers.remove(t);
        receivers.add(t);
        currentCharLimit = t.getCharLimit();
    }

    public static void stopTextReceiver(TextReceiver t) {
        receivers.remove(t);
        if (receivers.size() > 0) {
            TextReceiver next = receivers.get(receivers.size() - 1);
            currentCharLimit = next.getCharLimit();
        }
    }

    static {
        BaseMod.subscribe(new TextInput());
        text = "";
        currentCharLimit = -1;
        receivers = new ArrayList();
    }

    @SpirePatch(clz=ScrollInputProcessor.class, method="keyUp")
    public static class receiveKeyUp {
        @SpirePrefixPatch
        public static SpireReturn<Boolean> onKeyUp(ScrollInputProcessor __instance, int keycode) {
            if (receivers.isEmpty()) {
                return SpireReturn.Continue();
            }
            return SpireReturn.Return((Object)((TextReceiver)receivers.get(receivers.size() - 1)).onKeyUp(keycode));
        }
    }

    @SpirePatch(clz=ScrollInputProcessor.class, method="keyDown")
    public static class receiveKeyDown {
        @SpirePrefixPatch
        public static SpireReturn<Boolean> onKeyDown(ScrollInputProcessor __instance, int keycode) {
            if (receivers.isEmpty()) {
                return SpireReturn.Continue();
            }
            return SpireReturn.Return((Object)((TextReceiver)receivers.get(receivers.size() - 1)).onKeyDown(keycode));
        }
    }

    @SpirePatch(clz=ScrollInputProcessor.class, method="keyTyped")
    public static class receiveTyping {
        @SpirePrefixPatch
        public static SpireReturn<Boolean> readKeyboardInput(ScrollInputProcessor __instance, char character) {
            String s;
            if (receivers.isEmpty()) {
                return SpireReturn.Continue();
            }
            TextReceiver t = (TextReceiver)receivers.get(receivers.size() - 1);
            String text = t.getCurrentText();
            switch (character) {
                case '\n': 
                case '\r': {
                    if (t.onPushEnter()) {
                        return SpireReturn.Return((Object)true);
                    }
                }
                case '\t': {
                    if (t.onPushTab()) {
                        return SpireReturn.Return((Object)true);
                    }
                }
                case '\b': {
                    if (!t.onPushBackspace()) break;
                    return SpireReturn.Return((Object)true);
                }
                default: {
                    if (character >= ' ') break;
                    return SpireReturn.Continue();
                }
            }
            if (UIUtils.isMac && Gdx.input.isKeyPressed(63)) {
                return SpireReturn.Continue();
            }
            boolean backspace = character == '\b';
            boolean add = t.acceptCharacter(character);
            if (backspace && text.length() > 1) {
                t.setText(text.substring(0, text.length() - 1));
                return SpireReturn.Return((Object)true);
            }
            if (backspace) {
                t.setText("");
                return SpireReturn.Return((Object)true);
            }
            if (add && (currentCharLimit == -1 || text.length() < currentCharLimit) && (s = t.getAppendedText(character)) != null) {
                t.setText(text.concat(s));
                return SpireReturn.Return((Object)true);
            }
            return SpireReturn.Continue();
        }
    }
}

