/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.helpers.TipHelper;

import basemod.ReflectionHacks;
import basemod.helpers.CardPowerTip;
import basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard.AlternateCardCosts;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

public class CardPowerTipsInTipHelperPatch {
    private static Float boxW;
    private static Float boxEdgeH;

    private static class OffsetLocator
    extends SpireInsertLocator {
        private OffsetLocator() {
        }

        public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
            Matcher.MethodCallMatcher finalMatcher = new Matcher.MethodCallMatcher(GlyphLayout.class, "setText");
            return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
        }
    }

    @SpirePatch(clz=TipHelper.class, method="renderPowerTips")
    public static class FixOffsetPatch {
        @SpireInsertPatch(locator=OffsetLocator.class, localvars={"tip", "offsetChange"})
        public static void Insert(float x, float y, SpriteBatch sb, ArrayList<PowerTip> powerTips, PowerTip powerTip, @ByRef float[] offsetChange) {
            if (powerTip instanceof CardPowerTip && (powerTip.body == null || powerTip.header == null)) {
                if (boxEdgeH == null) {
                    boxEdgeH = Float.valueOf(((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BOX_EDGE_H")).floatValue() * 3.15f);
                }
                offsetChange[0] = offsetChange[0] - boxEdgeH.floatValue();
            }
        }
    }

    private static class Locator
    extends SpireInsertLocator {
        private Locator() {
        }

        public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
            Matcher.MethodCallMatcher finalMatcher = new Matcher.MethodCallMatcher(GlyphLayout.class, "setText");
            return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
        }
    }

    @SpirePatch(clz=TipHelper.class, method="renderPowerTips")
    public static class RenderCardPatch {
        @SpireInsertPatch(locator=Locator.class, localvars={"tip"})
        public static void Insert(float x, float y, SpriteBatch sb, ArrayList<PowerTip> powerTips, PowerTip tip) {
            if (tip instanceof CardPowerTip) {
                if (boxW == null) {
                    boxW = (Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BOX_W");
                }
                AbstractCard card = ((CardPowerTip)tip).card;
                card.current_x = x + boxW.floatValue() / 2.0f;
                card.current_y = y - (((CardPowerTip)tip).textHeight + AbstractCard.IMG_HEIGHT / 2.0f * ((CardPowerTip)tip).cardScale);
                if (((CardPowerTip)tip).body != null) {
                    if (boxEdgeH == null) {
                        boxEdgeH = Float.valueOf(((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BOX_EDGE_H")).floatValue() * 3.15f);
                    }
                    card.current_y -= boxEdgeH.floatValue() / 4.0f * 3.0f;
                }
                card.drawScale = ((CardPowerTip)tip).cardScale;
                card.render(sb);
            }
        }
    }

    @SpirePatch(clz=TipHelper.class, method="renderPowerTips")
    public static class SkipTipBoxPatch {
        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals(TipHelper.class.getName()) && m.getMethodName().equals("renderTipBox")) {
                        String manager = AlternateCardCosts.class.getName();
                        String energy = EnergyPanel.class.getName();
                        m.replace("if (tip.header != null && tip.body != null) {$proceed($$);} else {tip.header = \"\";}");
                    }
                }
            };
        }
    }

    @SpirePatch(clz=TipHelper.class, method="getPowerTipHeight")
    public static class PowerTipHeightPatch {
        public static SpireReturn<Float> Prefix(PowerTip powerTip) {
            if (powerTip instanceof CardPowerTip && (powerTip.header == null || powerTip.body == null)) {
                if (boxEdgeH == null) {
                    boxEdgeH = Float.valueOf(((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BOX_EDGE_H")).floatValue() * 3.15f);
                }
                return SpireReturn.Return((Object)Float.valueOf(AbstractCard.IMG_HEIGHT * ((CardPowerTip)powerTip).cardScale + boxEdgeH.floatValue() / 2.0f));
            }
            return SpireReturn.Continue();
        }

        public static float Postfix(float __result, PowerTip powerTip) {
            if (powerTip instanceof CardPowerTip && powerTip.header != null && powerTip.body != null) {
                ((CardPowerTip)powerTip).textHeight = __result;
                if (boxEdgeH == null) {
                    boxEdgeH = Float.valueOf(((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BOX_EDGE_H")).floatValue() * 3.15f);
                }
                return __result + AbstractCard.IMG_HEIGHT * ((CardPowerTip)powerTip).cardScale + boxEdgeH.floatValue() / 2.0f;
            }
            return __result;
        }
    }
}

