/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.characters.AbstractPlayer;

import basemod.BaseMod;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireField;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatches;
import com.google.gson.annotations.SerializedName;
import com.megacrit.cardcrawl.actions.common.BetterDiscardPileToHandAction;
import com.megacrit.cardcrawl.actions.common.BetterDrawPileToHandAction;
import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.actions.common.MakeTempCardInHandAction;
import com.megacrit.cardcrawl.actions.defect.DiscardPileToHandAction;
import com.megacrit.cardcrawl.actions.defect.ScrapeAction;
import com.megacrit.cardcrawl.actions.defect.SeekAction;
import com.megacrit.cardcrawl.actions.unique.AttackFromDeckToHandAction;
import com.megacrit.cardcrawl.actions.unique.DiscoveryAction;
import com.megacrit.cardcrawl.actions.unique.ExhumeAction;
import com.megacrit.cardcrawl.actions.unique.SkillFromDeckToHandAction;
import com.megacrit.cardcrawl.actions.utility.DiscardToHandAction;
import com.megacrit.cardcrawl.actions.utility.DrawPileToHandAction;
import com.megacrit.cardcrawl.actions.utility.ExhaustToHandAction;
import com.megacrit.cardcrawl.actions.watcher.FlickerReturnToHandAction;
import com.megacrit.cardcrawl.actions.watcher.ForeignInfluenceAction;
import com.megacrit.cardcrawl.actions.watcher.MeditateAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.purple.Scrawl;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.saveAndContinue.SaveFile;
import java.util.ArrayList;
import java.util.HashMap;
import javassist.CannotCompileException;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.convert.Transformer;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.apache.logging.log4j.Logger;

@SpirePatches(value={@SpirePatch(clz=DrawCardAction.class, method="update"), @SpirePatch(clz=AbstractPlayer.class, method="draw", paramtypez={}), @SpirePatch(clz=MakeTempCardInHandAction.class, method="update"), @SpirePatch(clz=ScrapeAction.class, method="update"), @SpirePatch(clz=SeekAction.class, method="update"), @SpirePatch(clz=AttackFromDeckToHandAction.class, method="update"), @SpirePatch(clz=ExhumeAction.class, method="update"), @SpirePatch(clz=SkillFromDeckToHandAction.class, method="update"), @SpirePatch(clz=DrawPileToHandAction.class, method="update"), @SpirePatch(clz=DiscoveryAction.class, method="update"), @SpirePatch(clz=Scrawl.class, method="use"), @SpirePatch(clz=ForeignInfluenceAction.class, method="update"), @SpirePatch(clz=MeditateAction.class, method="update"), @SpirePatch(clz=FlickerReturnToHandAction.class, method="update"), @SpirePatch(clz=DiscardToHandAction.class, method="update"), @SpirePatch(clz=DiscardPileToHandAction.class, method="update"), @SpirePatch(clz=BetterDiscardPileToHandAction.class, method="update"), @SpirePatch(clz=DrawPileToHandAction.class, method="update"), @SpirePatch(clz=BetterDrawPileToHandAction.class, method="update"), @SpirePatch(clz=ExhaustToHandAction.class, method="update")})
public class MaxHandSizePatch {
    public static void Raw(CtBehavior ctMethodToPatch) throws CannotCompileException {
        TestCodeConverter codeConverter = new TestCodeConverter();
        codeConverter.bipush(10);
        ctMethodToPatch.instrument((CodeConverter)codeConverter);
    }

    @SpirePatch(clz=CardCrawlGame.class, method="loadPlayerSave")
    public static class Load {
        @SpireInsertPatch(locator=Locator.class, localvars={"saveFile"})
        public static void Insert(CardCrawlGame __instance, AbstractPlayer p, SaveFile saveFile) {
            BaseMod.MAX_HAND_SIZE = (Integer)SaveField.maxHandSize.get((Object)saveFile);
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctBehavior) throws Exception {
                Matcher.FieldAccessMatcher finalMatcher = new Matcher.FieldAccessMatcher(SaveFile.class, "hand_size");
                return LineFinder.findInOrder((CtBehavior)ctBehavior, new ArrayList(), (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatch(clz=SaveAndContinue.class, method="save")
    public static class Save {
        @SpireInsertPatch(locator=Locator.class, localvars={"params"})
        public static void Insert(SaveFile save, @ByRef HashMap<Object, Object>[] params) {
            params[0].put("basemod:max_hand_size", SaveField.maxHandSize.get((Object)save));
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctBehavior) throws Exception {
                Matcher.FieldAccessMatcher finalMatcher = new Matcher.FieldAccessMatcher(SaveFile.class, "hand_size");
                return LineFinder.findInOrder((CtBehavior)ctBehavior, new ArrayList(), (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatch(clz=SaveFile.class, method="<class>")
    public static class SaveField {
        @SerializedName(value="basemod:max_hand_size")
        public static SpireField<Integer> maxHandSize = new SpireField(() -> BaseMod.MAX_HAND_SIZE);
    }

    @SpirePatch(clz=CardGroup.class, method="refreshHandLayout")
    public static class RefreshHandLayout {
        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals(Logger.class.getName()) && m.getMethodName().equals("info")) {
                        m.replace(RefreshHandLayout.class.getName() + ".PositionCards(this);");
                    }
                }
            };
        }

        public static void PositionCards(CardGroup hand) {
            float middle = (float)hand.size() / 2.0f - 0.5f;
            float index = 0.0f;
            for (AbstractCard card : hand.group) {
                card.targetDrawScale = 1500.0f * Settings.scale / (AbstractCard.IMG_WIDTH_S * (float)hand.size());
                card.target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * card.targetDrawScale * (index - middle);
                if (card.target_y < 0.0f * Settings.scale) {
                    card.target_y = 0.0f * Settings.scale;
                }
                if (Math.abs(card.targetAngle) > 20.0f) {
                    card.targetAngle = Math.signum(card.targetAngle) * 20.0f;
                }
                index += 1.0f;
            }
        }
    }

    public static class TestCodeConverter
    extends CodeConverter {
        public void bipush(int value) {
            this.transformers = new TransformBipush(this.transformers, value);
        }
    }

    public static class TransformBipush
    extends Transformer {
        protected int value;
        protected CodeAttribute codeAttr;

        public TransformBipush(Transformer next, int value) {
            super(next);
            this.value = value;
        }

        public void initialize(ConstPool cp, CodeAttribute attr) {
            this.codeAttr = attr;
        }

        public int transform(CtClass clazz, int pos, CodeIterator iterator, ConstPool cp) throws CannotCompileException, BadBytecode {
            int c = iterator.byteAt(pos);
            if (c == 16) {
                int v = iterator.byteAt(pos + 1);
                if (v == this.value) {
                    iterator.writeByte(0, pos);
                    iterator.writeByte(0, pos + 1);
                    Bytecode bytecode = new Bytecode(cp);
                    bytecode.addGetstatic(BaseMod.class.getName(), "MAX_HAND_SIZE", Descriptor.of((CtClass)CtClass.intType));
                    iterator.insert(pos, bytecode.get());
                } else if (v == this.value - 1) {
                    iterator.writeByte(0, pos);
                    iterator.writeByte(0, pos + 1);
                    Bytecode bytecode = new Bytecode(cp);
                    bytecode.addGetstatic(BaseMod.class.getName(), "MAX_HAND_SIZE", Descriptor.of((CtClass)CtClass.intType));
                    bytecode.addIconst(1);
                    bytecode.add(100);
                    iterator.insert(pos, bytecode.get());
                }
            }
            return pos;
        }
    }
}

