/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard;

import basemod.BaseMod;
import basemod.abstracts.CustomCard;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderFixSwitches {
    private static Method renderHelperMethod;
    private static Method renderHelperMethodWithScale;

    private static void renderHelper(AbstractCard card, SpriteBatch sb, Color color, TextureAtlas.AtlasRegion region, float xPos, float yPos) {
        try {
            renderHelperMethod.invoke((Object)card, sb, color, region, Float.valueOf(xPos), Float.valueOf(yPos));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void renderHelper(AbstractCard card, SpriteBatch sb, Color color, TextureAtlas.AtlasRegion region, float xPos, float yPos, float scale) {
        try {
            renderHelperMethodWithScale.invoke((Object)card, sb, color, region, Float.valueOf(xPos), Float.valueOf(yPos), Float.valueOf(scale));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void dynamicFrameRenderHelper(SpriteBatch sb, TextureAtlas.AtlasRegion img, float x, float y, float xOffset, float drawScale, float angle, float xScale) {
        sb.draw((TextureRegion)img, x + img.offsetX - (float)img.originalWidth / 2.0f + xOffset * drawScale, y + img.offsetY - (float)img.originalHeight / 2.0f, (float)img.originalWidth / 2.0f - img.offsetX, (float)img.originalHeight / 2.0f - img.offsetY, (float)img.packedWidth, (float)img.packedHeight, drawScale * Settings.scale * xScale, drawScale * Settings.scale, angle);
    }

    static {
        try {
            renderHelperMethod = AbstractCard.class.getDeclaredMethod("renderHelper", SpriteBatch.class, Color.class, TextureAtlas.AtlasRegion.class, Float.TYPE, Float.TYPE);
            renderHelperMethod.setAccessible(true);
            renderHelperMethodWithScale = AbstractCard.class.getDeclaredMethod("renderHelper", SpriteBatch.class, Color.class, TextureAtlas.AtlasRegion.class, Float.TYPE, Float.TYPE, Float.TYPE);
            renderHelperMethodWithScale.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderCardBg")
    public static class RenderBgSwitch {
        public static SpireReturn<?> Prefix(AbstractCard __instance, SpriteBatch sb, float xPos, float yPos, Color ___renderColor) {
            if (!(__instance instanceof CustomCard) || BaseMod.isBaseGameCardColor(__instance.color)) {
                return SpireReturn.Continue();
            }
            AbstractCard.CardColor color = __instance.color;
            CustomCard card = (CustomCard)__instance;
            Texture texture = null;
            TextureAtlas.AtlasRegion region = null;
            if (card.textureBackgroundSmallImg != null && !card.textureBackgroundSmallImg.isEmpty()) {
                texture = card.getBackgroundSmallTexture();
            } else {
                switch (card.type) {
                    case POWER: {
                        if (BaseMod.getPowerBgTexture(color) == null) {
                            BaseMod.savePowerBgTexture(color, ImageMaster.loadImage((String)BaseMod.getPowerBg(color)));
                        }
                        texture = BaseMod.getPowerBgTexture(color);
                        break;
                    }
                    case ATTACK: {
                        if (BaseMod.getAttackBgTexture(color) == null) {
                            BaseMod.saveAttackBgTexture(color, ImageMaster.loadImage((String)BaseMod.getAttackBg(color)));
                        }
                        texture = BaseMod.getAttackBgTexture(color);
                        break;
                    }
                    case SKILL: {
                        if (BaseMod.getSkillBgTexture(color) == null) {
                            BaseMod.saveSkillBgTexture(color, ImageMaster.loadImage((String)BaseMod.getSkillBg(color)));
                        }
                        texture = BaseMod.getSkillBgTexture(color);
                        break;
                    }
                    default: {
                        region = ImageMaster.CARD_SKILL_BG_BLACK;
                    }
                }
            }
            if (texture != null) {
                region = new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
            }
            if (region == null) {
                BaseMod.logger.info(color.toString() + " texture is null wtf");
                return SpireReturn.Continue();
            }
            RenderFixSwitches.renderHelper(card, sb, ___renderColor, region, xPos, yPos);
            return SpireReturn.Return(null);
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderOuterGlow")
    public static class RenderOuterGlowSwitch {
        public static final Logger logger = LogManager.getLogger((String)BaseMod.class.getName());

        @SpireInsertPatch(rloc=9)
        public static void Insert(AbstractCard __instance, SpriteBatch sb, float ___current_x, float ___current_y, Color ___tintColor) {
            if (!BaseMod.isBaseGameCardColor(__instance.color)) {
                Color glowColor = BaseMod.getGlowColor(__instance.color);
                if (glowColor == null) {
                    glowColor = Color.WHITE;
                }
                RenderFixSwitches.renderHelper(__instance, sb, glowColor, __instance.getCardBgAtlas(), ___current_x - 256.0f, ___current_y - 256.0f, 1.0f + ___tintColor.a / 5.0f);
            }
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderEnergy")
    public static class RenderEnergySwitch {
        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals(AbstractCard.class.getName()) && m.getMethodName().equals("renderHelper")) {
                        m.replace("{$3 = " + RenderEnergySwitch.class.getName() + ".getEnergyOrb(this, $3);$_ = $proceed($$);}");
                    }
                }
            };
        }

        @SpireInsertPatch(locator=Locator.class, localvars={"text", "font", "costColor"})
        public static void Insert(AbstractCard __instance, SpriteBatch sb, String text, BitmapFont font, Color costColor) {
            if (__instance.type == AbstractCard.CardType.STATUS && !__instance.cardID.equals("Slimed") || __instance.color == AbstractCard.CardColor.CURSE && !__instance.cardID.equals("Pride")) {
                FontHelper.renderRotatedText((SpriteBatch)sb, (BitmapFont)font, (String)text, (float)__instance.current_x, (float)__instance.current_y, (float)(-132.0f * __instance.drawScale * Settings.scale), (float)(192.0f * __instance.drawScale * Settings.scale), (float)__instance.angle, (boolean)false, (Color)costColor);
            }
        }

        public static TextureAtlas.AtlasRegion getEnergyOrb(AbstractCard card, TextureAtlas.AtlasRegion orb) {
            if (!(card instanceof CustomCard)) {
                return orb;
            }
            CustomCard ccard = (CustomCard)card;
            Texture texture = ccard.getOrbSmallTexture();
            if (texture != null) {
                return new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
            }
            Texture baseModTexture = BaseMod.getEnergyOrbTexture(card.color);
            if (baseModTexture != null) {
                return new TextureAtlas.AtlasRegion(baseModTexture, 0, 0, baseModTexture.getWidth(), baseModTexture.getHeight());
            }
            switch (card.color) {
                case BLUE: {
                    return ImageMaster.CARD_BLUE_ORB;
                }
                case GREEN: {
                    return ImageMaster.CARD_GREEN_ORB;
                }
                case RED: {
                    return ImageMaster.CARD_RED_ORB;
                }
                case PURPLE: {
                    return ImageMaster.CARD_PURPLE_ORB;
                }
                case COLORLESS: 
                case CURSE: {
                    return ImageMaster.CARD_COLORLESS_ORB;
                }
            }
            texture = ImageMaster.loadImage((String)BaseMod.getEnergyOrb(card.color));
            BaseMod.saveEnergyOrbTexture(card.color, texture);
            return new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctBehavior) throws Exception {
                Matcher.FieldAccessMatcher matcher = new Matcher.FieldAccessMatcher(AbstractCard.class, "type");
                return LineFinder.findInOrder((CtBehavior)ctBehavior, (Matcher)matcher);
            }
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderPortraitFrame")
    public static class RenderPortraitFrameSwitch {
        public static SpireReturn<?> Prefix(AbstractCard __instance, SpriteBatch sb, float x, float y, Color ___renderColor) {
            if (!(__instance instanceof CustomCard)) {
                return SpireReturn.Continue();
            }
            CustomCard card = (CustomCard)__instance;
            if (card.frameSmallRegion != null) {
                RenderFixSwitches.renderHelper(card, sb, ___renderColor, card.frameSmallRegion, x, y);
                if (card.frameMiddleRegion != null) {
                    float tWidth = 0.0f;
                    float tOffset = 0.0f;
                    switch (card.type) {
                        case ATTACK: {
                            tWidth = AbstractCard.typeWidthAttack;
                            tOffset = AbstractCard.typeOffsetAttack;
                            break;
                        }
                        case SKILL: {
                            tWidth = AbstractCard.typeWidthSkill;
                            tOffset = AbstractCard.typeOffsetSkill;
                            break;
                        }
                        case POWER: {
                            tWidth = AbstractCard.typeWidthPower;
                            tOffset = AbstractCard.typeOffsetPower;
                            break;
                        }
                        case STATUS: {
                            tWidth = AbstractCard.typeWidthStatus;
                            tOffset = AbstractCard.typeOffsetStatus;
                            break;
                        }
                        case CURSE: {
                            tWidth = AbstractCard.typeWidthCurse;
                            tOffset = AbstractCard.typeOffsetCurse;
                        }
                    }
                    if (tWidth > 1.1f) {
                        RenderFixSwitches.dynamicFrameRenderHelper(sb, ImageMaster.CARD_COMMON_FRAME_MID, x, y, 0.0f, __instance.drawScale, __instance.angle, tWidth);
                        RenderFixSwitches.dynamicFrameRenderHelper(sb, ImageMaster.CARD_COMMON_FRAME_LEFT, x, y, -tOffset, __instance.drawScale, __instance.angle, 1.0f);
                        RenderFixSwitches.dynamicFrameRenderHelper(sb, ImageMaster.CARD_COMMON_FRAME_RIGHT, x, y, tOffset, __instance.drawScale, __instance.angle, 1.0f);
                    }
                }
                return SpireReturn.Return(null);
            }
            return SpireReturn.Continue();
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderBannerImage")
    public static class RenderBannerSwitch {
        public static SpireReturn<?> Prefix(AbstractCard __instance, SpriteBatch sb, float drawX, float drawY, Color ___renderColor) {
            if (!(__instance instanceof CustomCard)) {
                return SpireReturn.Continue();
            }
            CustomCard card = (CustomCard)__instance;
            TextureAtlas.AtlasRegion region = card.getBannerSmallRegion();
            if (region == null) {
                return SpireReturn.Continue();
            }
            RenderFixSwitches.renderHelper(card, sb, ___renderColor, region, drawX, drawY);
            return SpireReturn.Return(null);
        }
    }
}

