/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard;

import basemod.abstracts.CustomCard;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import java.util.ArrayList;
import javassist.CtBehavior;

public class RenderCardDescriptors {
    public static final String SEPARATOR = " | ";

    @SpirePatch(clz=AbstractCard.class, method="dynamicFrameRenderHelper", paramtypez={SpriteBatch.class, TextureAtlas.AtlasRegion.class, float.class, float.class, float.class, float.class})
    public static class FixDynamicFrame {
        private static final Vector2 tmp = new Vector2(0.0f, 0.0f);

        public static SpireReturn<Void> Prefix(AbstractCard __instance, SpriteBatch sb, TextureAtlas.AtlasRegion img, float x, float y, float xOffset, float xScale) {
            if (__instance instanceof CustomCard) {
                tmp.set(xOffset, 0.0f);
                tmp.scl(__instance.drawScale);
                tmp.rotate(__instance.angle);
                sb.draw((TextureRegion)img, x + img.offsetX - ((float)img.originalWidth / 2.0f + 1.0f) + FixDynamicFrame.tmp.x, y + img.offsetY - (float)img.originalHeight / 2.0f + FixDynamicFrame.tmp.y, (float)img.originalWidth / 2.0f - img.offsetX + 1.0f, (float)img.originalHeight / 2.0f - img.offsetY, (float)img.packedWidth, (float)img.packedHeight, Settings.scale * __instance.drawScale * xScale, Settings.scale * __instance.drawScale, __instance.angle);
                return SpireReturn.Return(null);
            }
            return SpireReturn.Continue();
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderPortraitFrame")
    public static class Frame {
        @SpireInsertPatch(locator=Locator.class, localvars={"tOffset", "tWidth"})
        public static void Insert(AbstractCard __instance, SpriteBatch sb, float x, float y, @ByRef float[] tOffset, @ByRef float[] tWidth) {
            if (__instance instanceof CustomCard) {
                String typeText;
                switch (__instance.type) {
                    case ATTACK: {
                        typeText = AbstractCard.TEXT[0];
                        break;
                    }
                    case SKILL: {
                        typeText = AbstractCard.TEXT[1];
                        break;
                    }
                    case POWER: {
                        typeText = AbstractCard.TEXT[2];
                        break;
                    }
                    case STATUS: {
                        typeText = AbstractCard.TEXT[7];
                        break;
                    }
                    case CURSE: {
                        typeText = AbstractCard.TEXT[3];
                        break;
                    }
                    default: {
                        typeText = AbstractCard.TEXT[5];
                    }
                }
                ArrayList<String> descriptors = new ArrayList<String>();
                descriptors.add(typeText);
                descriptors.addAll(((CustomCard)__instance).getCardDescriptors());
                if (descriptors.size() > 1) {
                    String text = String.join((CharSequence)RenderCardDescriptors.SEPARATOR, descriptors);
                    GlyphLayout gl = new GlyphLayout();
                    FontHelper.cardTypeFont.getData().setScale(1.0f);
                    gl.setText(FontHelper.cardTypeFont, (CharSequence)text);
                    tOffset[0] = (gl.width - 38.0f * Settings.scale) / 2.0f;
                    tWidth[0] = (gl.width - 0.0f) / (32.0f * Settings.scale);
                }
            }
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctBehavior) throws Exception {
                Matcher.MethodCallMatcher matcher = new Matcher.MethodCallMatcher(AbstractCard.class, "renderDynamicFrame");
                return LineFinder.findInOrder((CtBehavior)ctBehavior, (Matcher)matcher);
            }
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderType")
    public static class Text {
        @SpireInsertPatch(locator=Locator.class, localvars={"text"})
        public static void Insert(AbstractCard __instance, SpriteBatch sb, @ByRef String[] text) {
            if (__instance instanceof CustomCard) {
                ArrayList<String> descriptors = new ArrayList<String>();
                descriptors.add(text[0]);
                descriptors.addAll(((CustomCard)__instance).getCardDescriptors());
                if (descriptors.size() > 1) {
                    text[0] = String.join((CharSequence)RenderCardDescriptors.SEPARATOR, descriptors);
                }
            }
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctBehavior) throws Exception {
                Matcher.MethodCallMatcher matcher = new Matcher.MethodCallMatcher(FontHelper.class, "renderRotatedText");
                return LineFinder.findInOrder((CtBehavior)ctBehavior, (Matcher)matcher);
            }
        }
    }
}

