/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard;

import basemod.abstracts.AbstractCardModifier;
import basemod.interfaces.AlternateCardCostModifier;
import basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard.CardModifierPatches;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.EnergyManager;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import java.util.ArrayList;
import java.util.Iterator;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

public class AlternateCardCosts {
    public static ArrayList<AlternateCardCostModifier> modifiers(AbstractCard c) {
        ArrayList<AlternateCardCostModifier> alternateCosts = new ArrayList<AlternateCardCostModifier>();
        for (AbstractCardModifier mod : (ArrayList)CardModifierPatches.CardModifierFields.cardModifiers.get((Object)c)) {
            if (!(mod instanceof AlternateCardCostModifier)) continue;
            alternateCosts.add((AlternateCardCostModifier)((Object)mod));
        }
        if (AbstractDungeon.player != null) {
            for (AbstractPower power : AbstractDungeon.player.powers) {
                if (!(power instanceof AlternateCardCostModifier)) continue;
                alternateCosts.add((AlternateCardCostModifier)power);
            }
            for (AbstractRelic relic : AbstractDungeon.player.relics) {
                if (!(relic instanceof AlternateCardCostModifier)) continue;
                alternateCosts.add((AlternateCardCostModifier)relic);
            }
            for (AbstractCard card : AbstractDungeon.player.hand.group) {
                if (!(card instanceof AlternateCardCostModifier)) continue;
                alternateCosts.add((AlternateCardCostModifier)card);
            }
            for (AbstractCard card : AbstractDungeon.player.drawPile.group) {
                if (!(card instanceof AlternateCardCostModifier)) continue;
                alternateCosts.add((AlternateCardCostModifier)card);
            }
            for (AbstractCard card : AbstractDungeon.player.discardPile.group) {
                if (!(card instanceof AlternateCardCostModifier)) continue;
                alternateCosts.add((AlternateCardCostModifier)card);
            }
            if (AbstractDungeon.player.cardInUse instanceof AlternateCardCostModifier) {
                alternateCosts.add((AlternateCardCostModifier)AbstractDungeon.player.cardInUse);
            }
        }
        return alternateCosts;
    }

    public static int getPreEnergyResourceAmount(AbstractCard card) {
        int tmp = 0;
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            if (!mod.prioritizeAlternateCost(card) || mod.canSplitCost(card) || !mod.costEffectActive(card)) continue;
            tmp = Math.max(tmp, mod.getAlternateResource(card));
        }
        return tmp;
    }

    public static int getPostEnergyResourceAmount(AbstractCard card) {
        int tmp = 0;
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            if (mod.prioritizeAlternateCost(card) || mod.canSplitCost(card) || !mod.costEffectActive(card)) continue;
            tmp = Math.max(tmp, mod.getAlternateResource(card));
        }
        return tmp;
    }

    public static int getSplittableResourceAmount(AbstractCard card) {
        int tmp = EnergyPanel.totalCount;
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            int c;
            if (!mod.canSplitCost(card) || !mod.costEffectActive(card) || (c = mod.getAlternateResource(card)) <= -1) continue;
            tmp += c;
        }
        return tmp;
    }

    public static void spendPreEnergyResource(AbstractCard card) {
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            int c;
            if (!mod.prioritizeAlternateCost(card) || !mod.costEffectActive(card) || (c = mod.getAlternateResource(card)) < card.costForTurn) continue;
            mod.spendAlternateCost(card, card.costForTurn);
            return;
        }
    }

    public static void spendPostEnergyResource(AbstractCard card) {
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            int c;
            if (mod.prioritizeAlternateCost(card) || !mod.costEffectActive(card) || (c = mod.getAlternateResource(card)) < card.costForTurn) continue;
            mod.spendAlternateCost(card, card.costForTurn);
            return;
        }
    }

    public static int spendPreEnergySplittableResource(AbstractCard card) {
        AlternateCardCostModifier mod;
        int remainingCost = card.costForTurn;
        Iterator<AlternateCardCostModifier> iterator = AlternateCardCosts.modifiers(card).iterator();
        while (!(!iterator.hasNext() || (mod = iterator.next()).prioritizeAlternateCost(card) && mod.canSplitCost(card) && mod.costEffectActive(card) && (remainingCost = mod.spendAlternateCost(card, remainingCost)) <= 0)) {
        }
        return remainingCost;
    }

    public static void spendPostEnergySplittableResource(AbstractCard card, int remainingCost) {
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            if (mod.prioritizeAlternateCost(card) || !mod.canSplitCost(card) || !mod.costEffectActive(card) || (remainingCost = mod.spendAlternateCost(card, remainingCost)) > 0) continue;
            return;
        }
        System.out.println("CardModifierManager: WARNING: splittable resources spent for " + card + "without being sufficient!");
    }

    public static boolean hasEnoughAlternateCost(AbstractCard card) {
        int c;
        ArrayList<AlternateCardCostModifier> splittableCosts = new ArrayList<AlternateCardCostModifier>();
        ArrayList<AlternateCardCostModifier> nonSplittableCosts = new ArrayList<AlternateCardCostModifier>();
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            if (!mod.costEffectActive(card)) continue;
            if (mod.canSplitCost(card)) {
                splittableCosts.add(mod);
                continue;
            }
            nonSplittableCosts.add(mod);
        }
        int amt = EnergyPanel.totalCount;
        for (AlternateCardCostModifier mod : splittableCosts) {
            c = mod.getAlternateResource(card);
            if (c <= -1) continue;
            amt += c;
        }
        if (amt >= card.costForTurn) {
            return true;
        }
        for (AlternateCardCostModifier mod : nonSplittableCosts) {
            c = mod.getAlternateResource(card);
            if (c <= amt || (amt = c) < card.costForTurn) continue;
            return true;
        }
        return false;
    }

    public static String getCostString(AbstractCard card, String currentString, Color color) {
        for (AlternateCardCostModifier mod : AlternateCardCosts.modifiers(card)) {
            currentString = mod.replaceCostString(card, currentString, color);
        }
        return currentString;
    }

    @SpirePatch(clz=AbstractCard.class, method="hasEnoughEnergy")
    public static class AlternateCostsHasEnoughAlternateResource {
        @SpireInsertPatch(locator=Locator.class)
        public static SpireReturn<Boolean> Insert(AbstractCard __instance) {
            if (AlternateCardCosts.hasEnoughAlternateCost(__instance)) {
                return SpireReturn.Return((Object)true);
            }
            return SpireReturn.Continue();
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
                Matcher.FieldAccessMatcher finalMatcher = new Matcher.FieldAccessMatcher(AbstractCard.class, "costForTurn");
                return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatch(clz=AbstractCard.class, method="renderEnergy")
    public static class GetCardModifierCostString {
        @SpireInsertPatch(locator=Locator.class, localvars={"text", "costColor"})
        public static void Insert(AbstractCard __instance, SpriteBatch sb, @ByRef String[] text, Color color) {
            text[0] = AlternateCardCosts.getCostString(__instance, text[0], color);
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
                Matcher.MethodCallMatcher finalMatcher = new Matcher.MethodCallMatcher(AbstractCard.class, "getEnergyFont");
                return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
            }
        }
    }

    @SpirePatch(clz=AbstractPlayer.class, method="useCard")
    public static class CardModifierSpendResources {
        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals(EnergyManager.class.getName()) && m.getMethodName().equals("use")) {
                        String manager = AlternateCardCosts.class.getName();
                        String energy = EnergyPanel.class.getName();
                        m.replace("if (" + manager + ".getPreEnergyResourceAmount(c) >= c.costForTurn) {" + manager + ".spendPreEnergyResource(c);} else if (" + manager + ".getSplittableResourceAmount(c) >= c.costForTurn) {int tmp = " + manager + ".spendPreEnergySplittableResource(c);if (tmp > 0) {if (tmp > " + energy + ".totalCount) {tmp -= " + energy + ".totalCount;this.energy.use(" + energy + ".totalCount);" + manager + ".spendPostEnergySplittableResource(c, tmp);} else {this.energy.use(tmp);}}} else if (" + manager + ".getPostEnergyResourceAmount(c) >= c.costForTurn) {" + manager + ".spendPostEnergyResource(c);} else {" + manager + ".spendPreEnergySplittableResource(c);this.energy.use(" + energy + ".totalCount);" + manager + ".spendPostEnergySplittableResource(c, c.costForTurn);}");
                    }
                }
            };
        }
    }
}

