/*
 * Decompiled with CFR 0.152.
 */
package basemod.helpers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class VfxBuilder {
    private float duration;
    public float scale = 1.0f;
    public float angle = 0.0f;
    public float alpha = 1.0f;
    public float x;
    public float y;
    private final TextureAtlas.AtlasRegion img;
    private Color color = Color.WHITE.cpy();
    private List<Predicate<Float>> updaters;
    private final Queue<List<Predicate<Float>>> animStages;
    private final Queue<Float> durationList;
    private final Queue<Consumer<VfxBuilder>> phaseCompleteCallbacks;
    private boolean additive = false;
    private BiConsumer<VfxBuilder, SpriteBatch> postRenderFn = null;
    private Consumer<VfxBuilder> phaseCompleteCallback = null;

    public VfxBuilder(TextureAtlas.AtlasRegion img, float x, float y, float duration) {
        this.img = img;
        this.x = x;
        this.y = y;
        this.duration = duration;
        this.updaters = new ArrayList<Predicate<Float>>();
        this.animStages = new LinkedList<List<Predicate<Float>>>();
        this.durationList = new LinkedList<Float>();
        this.phaseCompleteCallbacks = new LinkedList<Consumer<VfxBuilder>>();
    }

    public VfxBuilder(TextureAtlas.AtlasRegion img, float duration) {
        this(img, 0.0f, 0.0f, duration);
    }

    public VfxBuilder(float duration) {
        this((TextureAtlas.AtlasRegion)null, 0.0f, 0.0f, duration);
    }

    public VfxBuilder(Texture texture, float x, float y, float duration) {
        this(new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight()), x, y, duration);
    }

    public VfxBuilder(Texture texture, float duration) {
        this(texture, 0.0f, 0.0f, duration);
    }

    public static float calculateAngle(float currentX, float currentY, float targetX, float targetY) {
        return 57.295776f * MathUtils.atan2((float)(targetY - currentY), (float)(targetX - currentX));
    }

    public VfxBuilder useAdditiveBlending() {
        this.additive = true;
        return this;
    }

    private Function<Float, Float> interpolator(float from, float to, Interpolations interpolation) {
        switch (interpolation) {
            case BOUNCE: {
                return t -> Float.valueOf(Interpolation.bounce.apply(from, to, t.floatValue()));
            }
            case BOUNCEIN: {
                return t -> Float.valueOf(Interpolation.bounceIn.apply(from, to, t.floatValue()));
            }
            case BOUNCEOUT: {
                return t -> Float.valueOf(Interpolation.bounceOut.apply(from, to, t.floatValue()));
            }
            case CIRCLE: {
                return t -> Float.valueOf(Interpolation.circle.apply(from, to, t.floatValue()));
            }
            case CIRCLEIN: {
                return t -> Float.valueOf(Interpolation.circleIn.apply(from, to, t.floatValue()));
            }
            case CIRCLEOUT: {
                return t -> Float.valueOf(Interpolation.circleOut.apply(from, to, t.floatValue()));
            }
            case ELASTIC: {
                return t -> Float.valueOf(Interpolation.elastic.apply(from, to, t.floatValue()));
            }
            case ELASTICIN: {
                return t -> Float.valueOf(Interpolation.elasticIn.apply(from, to, t.floatValue()));
            }
            case ELASTICOUT: {
                return t -> Float.valueOf(Interpolation.elasticOut.apply(from, to, t.floatValue()));
            }
            case EXP5: {
                return t -> Float.valueOf(Interpolation.exp5.apply(from, to, t.floatValue()));
            }
            case EXP5IN: {
                return t -> Float.valueOf(Interpolation.exp5In.apply(from, to, t.floatValue()));
            }
            case EXP5OUT: {
                return t -> Float.valueOf(Interpolation.exp5Out.apply(from, to, t.floatValue()));
            }
            case EXP10: {
                return t -> Float.valueOf(Interpolation.exp10.apply(from, to, t.floatValue()));
            }
            case EXP10IN: {
                return t -> Float.valueOf(Interpolation.exp10In.apply(from, to, t.floatValue()));
            }
            case EXP10OUT: {
                return t -> Float.valueOf(Interpolation.exp10Out.apply(from, to, t.floatValue()));
            }
            case FADE: {
                return t -> Float.valueOf(Interpolation.fade.apply(from, to, t.floatValue()));
            }
            case POW2: {
                return t -> Float.valueOf(Interpolation.pow2.apply(from, to, t.floatValue()));
            }
            case POW2IN: {
                return t -> Float.valueOf(Interpolation.pow2In.apply(from, to, t.floatValue()));
            }
            case POW2IN_INVERSE: {
                return t -> Float.valueOf(Interpolation.pow2InInverse.apply(from, to, t.floatValue()));
            }
            case POW2OUT: {
                return t -> Float.valueOf(Interpolation.pow2Out.apply(from, to, t.floatValue()));
            }
            case POW2OUT_INVERSE: {
                return t -> Float.valueOf(Interpolation.pow2OutInverse.apply(from, to, t.floatValue()));
            }
            case POW3: {
                return t -> Float.valueOf(Interpolation.pow3.apply(from, to, t.floatValue()));
            }
            case POW3IN: {
                return t -> Float.valueOf(Interpolation.pow3In.apply(from, to, t.floatValue()));
            }
            case POW3IN_INVERSE: {
                return t -> Float.valueOf(Interpolation.pow3InInverse.apply(from, to, t.floatValue()));
            }
            case POW3OUT: {
                return t -> Float.valueOf(Interpolation.pow3Out.apply(from, to, t.floatValue()));
            }
            case POW3OUT_INVERSE: {
                return t -> Float.valueOf(Interpolation.pow3OutInverse.apply(from, to, t.floatValue()));
            }
            case POW4: {
                return t -> Float.valueOf(Interpolation.pow4.apply(from, to, t.floatValue()));
            }
            case POW4IN: {
                return t -> Float.valueOf(Interpolation.pow4In.apply(from, to, t.floatValue()));
            }
            case POW4OUT: {
                return t -> Float.valueOf(Interpolation.pow4Out.apply(from, to, t.floatValue()));
            }
            case POW5: {
                return t -> Float.valueOf(Interpolation.pow5.apply(from, to, t.floatValue()));
            }
            case POW5IN: {
                return t -> Float.valueOf(Interpolation.pow5In.apply(from, to, t.floatValue()));
            }
            case POW5OUT: {
                return t -> Float.valueOf(Interpolation.pow5Out.apply(from, to, t.floatValue()));
            }
            case SINE: {
                return t -> Float.valueOf(Interpolation.sine.apply(from, to, t.floatValue()));
            }
            case SINEIN: {
                return t -> Float.valueOf(Interpolation.sineIn.apply(from, to, t.floatValue()));
            }
            case SINEOUT: {
                return t -> Float.valueOf(Interpolation.sineOut.apply(from, to, t.floatValue()));
            }
            case SMOOTH: {
                return t -> Float.valueOf(Interpolation.smooth.apply(from, to, t.floatValue()));
            }
            case SMOOTH2: {
                return t -> Float.valueOf(Interpolation.smooth2.apply(from, to, t.floatValue()));
            }
            case SMOOTHER: {
                return t -> Float.valueOf(Interpolation.smoother.apply(from, to, t.floatValue()));
            }
            case SWING: {
                return t -> Float.valueOf(Interpolation.swing.apply(from, to, t.floatValue()));
            }
            case SWINGIN: {
                return t -> Float.valueOf(Interpolation.swingIn.apply(from, to, t.floatValue()));
            }
            case SWINGOUT: {
                return t -> Float.valueOf(Interpolation.swingOut.apply(from, to, t.floatValue()));
            }
        }
        return t -> Float.valueOf(Interpolation.linear.apply(from, to, t.floatValue()));
    }

    public VfxBuilder setX(float value) {
        this.updaters.add(t -> {
            this.x = value;
            return true;
        });
        return this;
    }

    public VfxBuilder setY(float value) {
        this.updaters.add(t -> {
            this.y = value;
            return true;
        });
        return this;
    }

    public VfxBuilder moveX(float from, float to, Interpolations interpolation) {
        Function<Float, Float> fn = this.interpolator(from, to, interpolation);
        this.updaters.add(t -> {
            this.x = ((Float)fn.apply(Float.valueOf(t.floatValue() / this.duration))).floatValue();
            return false;
        });
        return this;
    }

    public VfxBuilder moveX(float from, float to) {
        return this.moveX(from, to, Interpolations.EXP5);
    }

    public VfxBuilder oscillateX(float min, float max, float speed) {
        this.updaters.add(t -> {
            this.x = min + (max - min) * (MathUtils.sin((float)((float)Math.PI / 180 * t.floatValue() * speed)) / 2.0f + 0.5f);
            return false;
        });
        return this;
    }

    public VfxBuilder moveY(float from, float to, Interpolations interpolation) {
        Function<Float, Float> fn = this.interpolator(from, to, interpolation);
        this.updaters.add(t -> {
            this.y = ((Float)fn.apply(Float.valueOf(t.floatValue() / this.duration))).floatValue();
            return false;
        });
        return this;
    }

    public VfxBuilder moveY(float from, float to) {
        return this.moveY(from, to, Interpolations.EXP5);
    }

    public VfxBuilder oscillateY(float min, float max, float speed) {
        this.updaters.add(t -> {
            this.y = min + (max - min) * (MathUtils.sin((float)((float)Math.PI / 180 * t.floatValue() * speed)) / 2.0f + 0.5f);
            return false;
        });
        return this;
    }

    public VfxBuilder arc(float fromX, float fromY, float toX, float toY, float maxHeight) {
        Function<Float, Float> upFn = this.interpolator(fromY, maxHeight, Interpolations.CIRCLE);
        Function<Float, Float> downFn = this.interpolator(toY, maxHeight, Interpolations.CIRCLE);
        Function<Float, Float> xFn = this.interpolator(fromX, toX, Interpolations.LINEAR);
        this.updaters.add(t -> {
            this.x = ((Float)xFn.apply(Float.valueOf(t.floatValue() / this.duration))).floatValue();
            return false;
        });
        this.updaters.add(t -> {
            float halfDuration = this.duration / 2.0f;
            if (t.floatValue() > halfDuration) {
                return true;
            }
            this.y = ((Float)upFn.apply(Float.valueOf(t.floatValue() / halfDuration))).floatValue();
            return false;
        });
        this.updaters.add(t -> {
            float halfDuration = this.duration / 2.0f;
            if (t.floatValue() > halfDuration) {
                float a = MathUtils.clamp((float)(this.duration - t.floatValue()), (float)0.0f, (float)1.0f);
                this.y = ((Float)downFn.apply(Float.valueOf(a / halfDuration))).floatValue();
            }
            return false;
        });
        return this;
    }

    public VfxBuilder gravity(float strength) {
        this.updaters.add(t -> {
            this.y -= Settings.scale * strength * t.floatValue() / this.duration;
            return false;
        });
        return this;
    }

    public VfxBuilder velocity(float angle, float speed) {
        float rads = (float)Math.PI / 180 * angle;
        float scaledSpeed = speed * Settings.scale * Gdx.graphics.getDeltaTime();
        float dx = MathUtils.cos((float)rads) * scaledSpeed;
        float dy = MathUtils.sin((float)rads) * scaledSpeed;
        this.updaters.add(t -> {
            this.x += dx;
            this.y += dy;
            return false;
        });
        return this;
    }

    public VfxBuilder setColor(Color value) {
        this.color = value.cpy();
        return this;
    }

    public VfxBuilder setAlpha(float value) {
        this.alpha = value;
        return this;
    }

    public VfxBuilder fadeIn(float fadeTime) {
        this.updaters.add(t -> {
            this.alpha = Interpolation.fade.apply(t.floatValue() / fadeTime);
            return t.floatValue() > fadeTime;
        });
        return this;
    }

    public VfxBuilder fadeOut(float fadeTime) {
        this.updaters.add(t -> {
            float a = MathUtils.clamp((float)(this.duration - t.floatValue()), (float)0.0f, (float)fadeTime);
            this.alpha = t.floatValue() > this.duration - fadeTime ? Interpolation.fade.apply(a / fadeTime) : 1.0f;
            return false;
        });
        return this;
    }

    public VfxBuilder oscillateAlpha(float min, float max, float speed) {
        this.updaters.add(t -> {
            this.alpha = min + (max - min) * (MathUtils.sin((float)((float)Math.PI / 180 * t.floatValue() * speed)) / 2.0f + 0.5f);
            return false;
        });
        return this;
    }

    public VfxBuilder setScale(float value) {
        this.scale = value;
        return this;
    }

    public VfxBuilder scale(float from, float to, Interpolations interpolation) {
        Function<Float, Float> fn = this.interpolator(from, to, interpolation);
        this.updaters.add(t -> {
            this.scale = ((Float)fn.apply(Float.valueOf(t.floatValue() / this.duration))).floatValue();
            return false;
        });
        return this;
    }

    public VfxBuilder scale(float from, float to) {
        return this.scale(from, to, Interpolations.SWING);
    }

    public VfxBuilder oscillateScale(float min, float max, float speed) {
        this.updaters.add(t -> {
            this.scale = min + (max - min) * (MathUtils.sin((float)((float)Math.PI / 180 * t.floatValue() * speed)) / 2.0f + 0.5f);
            return false;
        });
        return this;
    }

    public VfxBuilder setAngle(float value) {
        this.angle = value;
        return this;
    }

    public VfxBuilder rotateTo(float fromAngle, float toAngle, Interpolations interpolation) {
        Function<Float, Float> fn = this.interpolator(fromAngle, toAngle, interpolation);
        this.updaters.add(t -> {
            this.angle = ((Float)fn.apply(Float.valueOf(t.floatValue() / this.duration))).floatValue();
            return false;
        });
        return this;
    }

    public VfxBuilder rotate(float speed) {
        this.updaters.add(t -> {
            this.angle += speed * Gdx.graphics.getDeltaTime();
            return false;
        });
        return this;
    }

    public VfxBuilder wobble(float startAngle, float otherAngle, float speed) {
        this.updaters.add(t -> {
            this.angle = startAngle + (otherAngle - startAngle) * (MathUtils.sin((float)((float)Math.PI / 180 * t.floatValue() * speed)) / 2.0f + 0.5f);
            return false;
        });
        return this;
    }

    public VfxBuilder playSoundAt(float timeOffset, float pitchAdjust, String key) {
        this.updaters.add(t -> {
            if (t.floatValue() >= timeOffset) {
                CardCrawlGame.sound.playA(key, pitchAdjust);
                return true;
            }
            return false;
        });
        return this;
    }

    public VfxBuilder playSoundAt(float timeOffset, String key) {
        this.updaters.add(t -> {
            if (t.floatValue() >= timeOffset) {
                CardCrawlGame.sound.play(key);
                return true;
            }
            return false;
        });
        return this;
    }

    public VfxBuilder triggerVfxAt(float timeOffset, int count, BiFunction<Float, Float, AbstractGameEffect> effectFn) {
        this.updaters.add(t -> {
            if (t.floatValue() >= timeOffset) {
                IntStream.rangeClosed(1, MathUtils.clamp((int)count, (int)1, (int)50)).forEachOrdered(i -> AbstractDungeon.effectsQueue.add(effectFn.apply(Float.valueOf(this.x), Float.valueOf(this.y))));
                return true;
            }
            return false;
        });
        return this;
    }

    public VfxBuilder emitEvery(BiFunction<Float, Float, AbstractGameEffect> effectGeneratorFn, float period) {
        IntStream.rangeClosed(1, (int)(this.duration / period)).forEachOrdered(offset -> this.updaters.add(t -> {
            if (t.floatValue() >= period * (float)offset) {
                AbstractDungeon.effectsQueue.add(effectGeneratorFn.apply(Float.valueOf(this.x), Float.valueOf(this.y)));
                return true;
            }
            return false;
        }));
        return this;
    }

    public VfxBuilder postRender(BiConsumer<VfxBuilder, SpriteBatch> callback) {
        this.postRenderFn = callback;
        return this;
    }

    public VfxBuilder andThen(float nextDuration) {
        this.animStages.add(this.updaters);
        this.durationList.add(Float.valueOf(this.duration));
        this.phaseCompleteCallbacks.add(this.phaseCompleteCallback);
        this.updaters = new ArrayList<Predicate<Float>>();
        this.duration = nextDuration;
        this.phaseCompleteCallback = null;
        return this;
    }

    public VfxBuilder whenStarted(Consumer<VfxBuilder> callback) {
        this.updaters.add(t -> {
            callback.accept(this);
            return true;
        });
        return this;
    }

    public VfxBuilder whenComplete(Consumer<VfxBuilder> callback) {
        this.phaseCompleteCallback = callback;
        return this;
    }

    private boolean nextStage() {
        if (this.phaseCompleteCallback != null) {
            this.phaseCompleteCallback.accept(this);
        }
        if (this.durationList.size() > 0) {
            this.duration = this.durationList.poll().floatValue();
            this.updaters = this.animStages.poll();
            this.phaseCompleteCallback = this.phaseCompleteCallbacks.poll();
            return false;
        }
        return true;
    }

    public AbstractGameEffect build() {
        this.durationList.add(Float.valueOf(this.duration));
        this.animStages.add(this.updaters);
        this.phaseCompleteCallbacks.add(this.phaseCompleteCallback);
        this.phaseCompleteCallback = null;
        this.nextStage();
        return new BuiltEffect(this);
    }

    public static enum Interpolations {
        BOUNCE,
        BOUNCEIN,
        BOUNCEOUT,
        CIRCLE,
        CIRCLEIN,
        CIRCLEOUT,
        ELASTIC,
        ELASTICIN,
        ELASTICOUT,
        EXP5,
        EXP5IN,
        EXP5OUT,
        EXP10,
        EXP10IN,
        EXP10OUT,
        FADE,
        LINEAR,
        POW2,
        POW2IN,
        POW2IN_INVERSE,
        POW2OUT,
        POW2OUT_INVERSE,
        POW3,
        POW3IN,
        POW3IN_INVERSE,
        POW3OUT,
        POW3OUT_INVERSE,
        POW4,
        POW4IN,
        POW4OUT,
        POW5,
        POW5IN,
        POW5OUT,
        SINE,
        SINEIN,
        SINEOUT,
        SMOOTH,
        SMOOTH2,
        SMOOTHER,
        SWING,
        SWINGIN,
        SWINGOUT;

    }

    private static class BuiltEffect
    extends AbstractGameEffect {
        private final VfxBuilder builder;
        private float t;

        public BuiltEffect(VfxBuilder builder) {
            this.builder = builder;
            this.t = 0.0f;
            this.startingDuration = this.duration = builder.duration;
        }

        public void update() {
            this.t += Gdx.graphics.getDeltaTime();
            this.builder.updaters.removeIf(fn -> fn.test(Float.valueOf(this.t)));
            if (this.t >= this.duration) {
                this.isDone = this.builder.nextStage();
                this.startingDuration = this.duration = this.builder.duration;
                this.t = 0.0f;
            }
        }

        public void render(SpriteBatch sb) {
            if (this.builder.img == null) {
                if (this.builder.postRenderFn != null) {
                    this.builder.postRenderFn.accept(this.builder, sb);
                }
                return;
            }
            Color color = this.builder.color;
            color.a = this.builder.alpha;
            sb.setColor(color);
            float halfW = (float)((VfxBuilder)this.builder).img.originalWidth / 2.0f;
            float halfH = (float)((VfxBuilder)this.builder).img.originalHeight / 2.0f;
            if (this.builder.additive) {
                sb.setBlendFunction(770, 1);
            }
            sb.draw((TextureRegion)this.builder.img, this.builder.x - (halfW - ((VfxBuilder)this.builder).img.offsetX), this.builder.y - (halfH - ((VfxBuilder)this.builder).img.offsetY), halfW - ((VfxBuilder)this.builder).img.offsetX, halfH - ((VfxBuilder)this.builder).img.offsetY, (float)((VfxBuilder)this.builder).img.packedWidth, (float)((VfxBuilder)this.builder).img.packedHeight, this.builder.scale * Settings.scale, this.builder.scale * Settings.scale, this.builder.angle);
            if (this.builder.additive) {
                sb.setBlendFunction(770, 771);
            }
            if (this.builder.postRenderFn != null) {
                this.builder.postRenderFn.accept(this.builder, sb);
            }
        }

        public void dispose() {
        }
    }
}

