/*
 * Decompiled with CFR 0.152.
 */
package basemod.helpers;

import basemod.BaseMod;
import basemod.abstracts.DynamicVariable;
import basemod.helpers.TooltipInfo;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModalChoice {
    private String title;
    private ArrayList<AbstractCard> cards;

    ModalChoice(String title, ArrayList<AbstractCard> options) {
        this.title = title;
        this.cards = options;
    }

    public AbstractCard getCard(int index) {
        return this.cards.get(index);
    }

    public void open() {
        final ArrayList<AbstractCard> cards_copy = new ArrayList<AbstractCard>(this.cards.size());
        for (AbstractCard c : this.cards) {
            AbstractCard copy = c.makeStatEquivalentCopy();
            copy.dontTriggerOnUseCard = true;
            copy.freeToPlayOnce = true;
            copy.purgeOnUse = copy.type != AbstractCard.CardType.POWER;
            cards_copy.add(copy);
        }
        AbstractDungeon.actionManager.addToBottom(new AbstractGameAction(){

            public void update() {
                BaseMod.modalChoiceScreen.open(cards_copy, ModalChoice.this.title);
                this.isDone = true;
            }
        });
    }

    public List<TooltipInfo> generateTooltips() {
        ArrayList<TooltipInfo> ret = new ArrayList<TooltipInfo>();
        for (AbstractCard card : this.cards) {
            TooltipInfo tooltipInfo = new TooltipInfo(card.name, card.rawDescription);
            ModalChoice.doDynamicVariables(card, tooltipInfo);
            ret.add(tooltipInfo);
        }
        return ret;
    }

    private static void doDynamicVariables(AbstractCard card, TooltipInfo tooltipInfo) {
        Pattern pattern = Pattern.compile("!(.+)!(.*)");
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(tooltipInfo.description);
        while (scanner.hasNext()) {
            String tmp = scanner.next();
            Matcher matcher = pattern.matcher(tmp);
            if (matcher.find()) {
                String key = matcher.group(1);
                int num = 0;
                DynamicVariable dv = BaseMod.cardDynamicVariableMap.get(key);
                if (dv != null) {
                    num = dv.isModified(card) ? dv.value(card) : dv.baseValue(card);
                }
                stringBuilder.append(num);
                stringBuilder.append(matcher.group(2));
            } else {
                stringBuilder.append(tmp);
            }
            stringBuilder.append(' ');
        }
        tooltipInfo.description = stringBuilder.toString();
    }

    public static interface Callback {
        public void optionSelected(AbstractPlayer var1, AbstractMonster var2, int var3);
    }
}

