/*
 * Decompiled with CFR 0.152.
 */
package basemod.helpers;

import basemod.abstracts.AbstractCardModifier;
import basemod.patches.com.megacrit.cardcrawl.cards.AbstractCard.CardModifierPatches;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class CardModifierManager {
    public static ArrayList<AbstractCardModifier> modifiers(AbstractCard c) {
        return (ArrayList)CardModifierPatches.CardModifierFields.cardModifiers.get((Object)c);
    }

    public static void addModifier(AbstractCard card, AbstractCardModifier mod) {
        if (mod.shouldApply(card)) {
            CardModifierManager.modifiers(card).add(mod);
            Collections.sort(CardModifierManager.modifiers(card));
            mod.onInitialApplication(card);
            card.initializeDescription();
        }
    }

    public static void removeSpecificModifier(AbstractCard card, AbstractCardModifier mod, boolean includeInherent) {
        if (CardModifierManager.modifiers(card).contains(mod) && (!mod.isInherent(card) || includeInherent)) {
            CardModifierManager.modifiers(card).remove(mod);
            mod.onRemove(card);
        }
        card.initializeDescription();
    }

    public static void removeModifiersById(AbstractCard card, String id, boolean includeInherent) {
        Iterator<AbstractCardModifier> it = CardModifierManager.modifiers(card).iterator();
        while (it.hasNext()) {
            AbstractCardModifier mod = it.next();
            if (!mod.identifier(card).equals(id) || mod.isInherent(card) && !includeInherent) continue;
            it.remove();
            mod.onRemove(card);
        }
        card.initializeDescription();
    }

    public static boolean hasModifier(AbstractCard card, String id) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            if (!mod.identifier(card).equals(id)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<AbstractCardModifier> getModifiers(AbstractCard card, String id) {
        ArrayList<AbstractCardModifier> retVal = new ArrayList<AbstractCardModifier>();
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            if (!mod.identifier(card).equals(id)) continue;
            retVal.add(mod);
        }
        return retVal;
    }

    public static void removeAllModifiers(AbstractCard card, boolean includeInherent) {
        Iterator<AbstractCardModifier> it = CardModifierManager.modifiers(card).iterator();
        while (it.hasNext()) {
            AbstractCardModifier mod = it.next();
            if (mod.isInherent(card) && !includeInherent) continue;
            it.remove();
            mod.onRemove(card);
        }
        card.initializeDescription();
    }

    public static void copyModifiers(AbstractCard oldCard, AbstractCard newCard, boolean includeInherent, boolean replace, boolean removeOld) {
        if (replace) {
            CardModifierManager.removeAllModifiers(newCard, includeInherent);
        }
        Iterator<AbstractCardModifier> it = CardModifierManager.modifiers(oldCard).iterator();
        while (it.hasNext()) {
            AbstractCardModifier newMod;
            AbstractCardModifier mod = it.next();
            if (mod.isInherent(oldCard) && !includeInherent) continue;
            if (removeOld) {
                it.remove();
                mod.onRemove(oldCard);
            }
            if (!(newMod = mod.makeCopy()).shouldApply(newCard)) continue;
            CardModifierManager.modifiers(newCard).add(newMod);
            newMod.onInitialApplication(newCard);
        }
        if (removeOld) {
            oldCard.initializeDescription();
        }
        newCard.initializeDescription();
    }

    public static void removeEndOfTurnModifiers(AbstractCard card) {
        Iterator<AbstractCardModifier> it = CardModifierManager.modifiers(card).iterator();
        while (it.hasNext()) {
            AbstractCardModifier mod = it.next();
            if (!mod.removeAtEndOfTurn(card)) continue;
            it.remove();
            mod.onRemove(card);
        }
        card.initializeDescription();
    }

    public static void removeWhenPlayedModifiers(AbstractCard card) {
        Iterator<AbstractCardModifier> it = CardModifierManager.modifiers(card).iterator();
        while (it.hasNext()) {
            AbstractCardModifier mod = it.next();
            if (!mod.removeOnCardPlayed(card)) continue;
            it.remove();
            mod.onRemove(card);
        }
        card.initializeDescription();
    }

    public static void onApplyPowers(AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onApplyPowers(card);
        }
    }

    public static void onCalculateCardDamage(AbstractCard card, AbstractMonster mo) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onCalculateCardDamage(card, mo);
        }
    }

    public static String onCreateDescription(AbstractCard card, String rawDescription) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            rawDescription = mod.modifyDescription(rawDescription, card);
        }
        return rawDescription;
    }

    public static void onUseCard(AbstractCard card, AbstractCreature target, UseCardAction action) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onUse(card, target, action);
        }
    }

    public static void onCardDrawn(AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onDrawn(card);
        }
    }

    public static void onCardExhausted(AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onExhausted(card);
        }
    }

    public static void onCardRetained(AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onRetained(card);
        }
    }

    public static float onModifyDamage(float damage, AbstractCard card, AbstractMonster mo) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            damage = mod.modifyDamage(damage, card.damageTypeForTurn, card, mo);
        }
        return damage;
    }

    public static float onModifyDamageFinal(float damage, AbstractCard card, AbstractMonster mo) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            damage = mod.modifyDamageFinal(damage, card.damageTypeForTurn, card, mo);
        }
        return damage;
    }

    public static float onModifyBlock(float block, AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            block = mod.modifyBlock(block, card);
        }
        return block;
    }

    public static float onModifyBlockFinal(float block, AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            block = mod.modifyBlockFinal(block, card);
        }
        return block;
    }

    public static void onUpdate(AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onUpdate(card);
        }
    }

    public static void onRender(AbstractCard card, SpriteBatch sb) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onRender(card, sb);
        }
    }

    public static void atEndOfTurn(AbstractCard card, CardGroup group) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.atEndOfTurn(card, group);
        }
    }

    public static void onOtherCardPlayed(AbstractCard card, AbstractCard otherCard, CardGroup group) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            mod.onOtherCardPlayed(card, otherCard, group);
        }
    }

    public static boolean canPlayCard(AbstractCard card) {
        for (AbstractCardModifier mod : CardModifierManager.modifiers(card)) {
            if (mod.canPlayCard(card)) continue;
            return false;
        }
        return true;
    }
}

