/*
 * Decompiled with CFR 0.152.
 */
package basemod.helpers;

import basemod.ReflectionHacks;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.vfx.cardManip.CardGlowBorder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javassist.CtBehavior;

public class CardBorderGlowManager {
    private static final Color defaultGlowColor = (Color)ReflectionHacks.getPrivateStatic(AbstractCard.class, "BLUE_BORDER_GLOW_COLOR");
    private static ArrayList<GlowInfo> glowInfo = new ArrayList();

    public static void addGlowInfo(GlowInfo newInfo) {
        boolean hasGlow = false;
        for (GlowInfo info : glowInfo) {
            if (!info.glowID().equals(newInfo.glowID())) continue;
            hasGlow = true;
        }
        if (!hasGlow) {
            glowInfo.add(newInfo);
            Collections.sort(glowInfo);
        }
    }

    public static void removeGlowInfo(GlowInfo info) {
        glowInfo.remove(info);
        Collections.sort(glowInfo);
    }

    public static void removeGlowInfo(String glowID) {
        GlowInfo info = null;
        for (GlowInfo i : glowInfo) {
            if (!i.glowID().equals(glowID)) continue;
            info = i;
            break;
        }
        if (info != null) {
            CardBorderGlowManager.removeGlowInfo(info);
        }
    }

    public static GlowInfo getGlowInfo(String glowID) {
        GlowInfo retVal = null;
        for (GlowInfo i : glowInfo) {
            if (!i.glowID().equals(glowID)) continue;
            retVal = i;
            break;
        }
        return retVal;
    }

    public static boolean hasCustomGlows(AbstractCard card) {
        for (GlowInfo glow : glowInfo) {
            if (!glow.test(card)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<GlowInfo> getCustomGlowColors(AbstractCard card) {
        ArrayList<GlowInfo> retVal = new ArrayList<GlowInfo>();
        for (GlowInfo info : glowInfo) {
            if (!info.test(card)) continue;
            retVal.add(info);
        }
        if (card.glowColor.r != CardBorderGlowManager.defaultGlowColor.r || card.glowColor.g != CardBorderGlowManager.defaultGlowColor.g || card.glowColor.b != CardBorderGlowManager.defaultGlowColor.b) {
            final Color color = card.glowColor.cpy();
            retVal.add(new GlowInfo(){

                @Override
                public boolean test(AbstractCard card) {
                    return false;
                }

                @Override
                public Color getColor(AbstractCard card) {
                    return color.cpy();
                }

                @Override
                public String glowID() {
                    return null;
                }
            });
        }
        return retVal;
    }

    @SpirePatch(clz=AbstractCard.class, method="renderGlow")
    public static class RenderGlowPatch {
        private static FrameBuffer fbo = RenderGlowPatch.createBuffer();
        private static FrameBuffer maskfbo = RenderGlowPatch.createBuffer();
        private static ShapeRenderer shape = new ShapeRenderer();
        private static TextureRegion currentMask = null;
        private static ArrayList<GlowInfo> colorTracker = null;
        private static HashMap<GlowInfo, MaskInfo> masks = null;
        private static GlowInfo currentRender = null;
        private static Color defaultColor = null;

        public static void Prefix(AbstractCard __instance, SpriteBatch sb) {
            if (!Settings.hideCards && (colorTracker != null || CardBorderGlowManager.hasCustomGlows(__instance))) {
                if (colorTracker == null) {
                    defaultColor = __instance.glowColor;
                    colorTracker = CardBorderGlowManager.getCustomGlowColors(__instance);
                    if (colorTracker.size() > 1) {
                        masks = new HashMap();
                        float segmentSize = 180.0f / (float)colorTracker.size();
                        float arcStart = -90.0f;
                        for (int i = 0; i < colorTracker.size(); ++i) {
                            MaskInfo mask = new MaskInfo(__instance.current_x, __instance.current_y, AbstractCard.IMG_HEIGHT, arcStart + __instance.angle, segmentSize + (i == 0 || i == colorTracker.size() - 1 ? 90.0f : 0.0f));
                            masks.put(colorTracker.get(i), mask);
                            if (i == 0) {
                                arcStart += 90.0f;
                            }
                            arcStart += segmentSize;
                        }
                    }
                }
                currentRender = colorTracker.get(0);
                colorTracker.remove(currentRender);
                if (masks != null) {
                    sb.end();
                    RenderGlowPatch.beginBuffer(maskfbo);
                    shape.begin(ShapeRenderer.ShapeType.Filled);
                    shape.setColor(Color.BLACK);
                    MaskInfo mask = masks.get(currentRender);
                    shape.arc(mask.x, mask.y, mask.radius, mask.start, mask.degrees);
                    shape.end();
                    maskfbo.end();
                    currentMask = RenderGlowPatch.getBufferTexture(maskfbo);
                    RenderGlowPatch.beginBuffer(fbo);
                    sb.begin();
                }
                __instance.glowColor = currentRender.getColor(__instance);
            }
        }

        public static void Postfix(AbstractCard __instance, SpriteBatch sb) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            if (!Settings.hideCards && colorTracker != null) {
                if (masks != null) {
                    sb.setColor(Color.WHITE.cpy());
                    sb.setBlendFunction(0, 770);
                    sb.draw(currentMask, 0.0f, 0.0f);
                    sb.end();
                    fbo.end();
                    TextureRegion texture = RenderGlowPatch.getBufferTexture(fbo);
                    sb.begin();
                    sb.setBlendFunction(1, 1);
                    sb.draw(texture, 0.0f, 0.0f);
                    sb.setBlendFunction(770, 771);
                }
                if (colorTracker.isEmpty()) {
                    colorTracker = null;
                    masks = null;
                    currentMask = null;
                    currentRender = null;
                    __instance.glowColor = defaultColor;
                    defaultColor = null;
                } else {
                    ReflectionHacks.privateMethod(AbstractCard.class, "renderGlow", SpriteBatch.class).invoke(__instance, sb);
                }
            }
        }

        public static FrameBuffer createBuffer() {
            return new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false, false);
        }

        public static void beginBuffer(FrameBuffer fbo) {
            fbo.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16640);
            Gdx.gl.glColorMask(true, true, true, true);
        }

        public static TextureRegion getBufferTexture(FrameBuffer fbo) {
            TextureRegion texture = new TextureRegion((Texture)fbo.getColorBufferTexture());
            texture.flip(false, true);
            return texture;
        }

        @SpirePatch(clz=CardGlowBorder.class, method="render")
        public static class CardGlowBorderEffectPatch {
            @SpireInsertPatch(locator=Locator.class)
            public static void Insert(CardGlowBorder __instance, SpriteBatch sb) {
                if (currentRender != null) {
                    Color color = currentRender.getColor((AbstractCard)ReflectionHacks.getPrivate(__instance, CardGlowBorder.class, "card"));
                    color.a = sb.getColor().a;
                    sb.setColor(color);
                }
            }

            private static class Locator
            extends SpireInsertLocator {
                private Locator() {
                }

                public int[] Locate(CtBehavior ctMethodToPatch) throws Exception {
                    Matcher.MethodCallMatcher finalMatcher = new Matcher.MethodCallMatcher(SpriteBatch.class, "draw");
                    return LineFinder.findInOrder((CtBehavior)ctMethodToPatch, (Matcher)finalMatcher);
                }
            }
        }

        public static class MaskInfo {
            public float x;
            public float y;
            public float radius;
            public float start;
            public float degrees;

            public MaskInfo(float x, float y, float radius, float start, float degrees) {
                this.x = x;
                this.y = y;
                this.radius = radius;
                this.start = start;
                this.degrees = degrees;
            }
        }
    }

    public static abstract class GlowInfo
    implements Comparable<GlowInfo> {
        int priority = 0;

        public abstract boolean test(AbstractCard var1);

        public abstract Color getColor(AbstractCard var1);

        public abstract String glowID();

        @Override
        public int compareTo(GlowInfo other) {
            return this.priority - other.priority;
        }
    }
}

