/*
 * Decompiled with CFR 0.152.
 */
package basemod.eventUtil.util;

import basemod.eventUtil.EventUtils;
import basemod.eventUtil.util.Condition;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public class ConditionalEvent<T extends AbstractEvent> {
    public Class<T> eventClass;
    public AbstractPlayer.PlayerClass playerClass;
    public Condition spawnCondition;
    public List<String> actIDs;
    public String overrideEvent = "";

    public ConditionalEvent(Class<T> eventClass, AbstractPlayer.PlayerClass playerClass, Condition spawnCondition, String[] actIDs) {
        this.eventClass = eventClass;
        this.playerClass = playerClass;
        this.spawnCondition = spawnCondition;
        if (spawnCondition == null) {
            this.spawnCondition = () -> true;
        }
        this.actIDs = Arrays.asList(actIDs);
    }

    public AbstractEvent getEvent() {
        try {
            return (AbstractEvent)this.eventClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            EventUtils.eventLogger.info("Failed to instantiate event " + this.eventClass.getName());
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValid() {
        return !(!this.actIDs.isEmpty() && !this.actIDs.contains(AbstractDungeon.id) || !this.spawnCondition.test() || this.playerClass != null && AbstractDungeon.player.chosenClass != this.playerClass);
    }

    public String toString() {
        return this.eventClass.getSimpleName();
    }

    public String getConditions() {
        return (this.playerClass != null ? this.playerClass.name().toUpperCase() : "ANY") + " | " + (this.actIDs.isEmpty() ? "ANY" : this.actIDs);
    }
}

