/*
 * Decompiled with CFR 0.152.
 */
package basemod.eventUtil;

import basemod.eventUtil.util.Condition;
import basemod.eventUtil.util.ConditionalEvent;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventUtils {
    public static Logger eventLogger = LogManager.getLogger((String)"EventUtil");
    public static HashMap<String, Condition> normalEventBonusConditions = new HashMap();
    public static HashMap<String, Condition> specialEventBonusConditions = new HashMap();
    public static HashMap<ConditionalEvent<? extends AbstractEvent>, Condition> overrideBonusConditions = new HashMap();
    public static HashMap<String, ConditionalEvent<? extends AbstractEvent>> normalEvents = new HashMap();
    public static HashMap<String, ConditionalEvent<? extends AbstractEvent>> shrineEvents = new HashMap();
    public static HashMap<String, ConditionalEvent<? extends AbstractEvent>> oneTimeEvents = new HashMap();
    public static HashMap<String, ConditionalEvent<? extends AbstractEvent>> fullReplaceEvents = new HashMap();
    public static HashMap<String, ArrayList<ConditionalEvent<? extends AbstractEvent>>> overrideEvents = new HashMap();
    public static HashMap<String, ArrayList<ConditionalEvent<? extends AbstractEvent>>> fullReplaceEventList = new HashMap();
    public static HashSet<String> eventIDs = new HashSet();
    private static int id = 0;

    public static <T extends AbstractEvent> void registerEvent(String ID, Class<T> eventClass, AbstractPlayer.PlayerClass playerClass, String[] actIDs, Condition spawnCondition, String overrideEvent, Condition bonusCondition, EventType type) {
        if (eventIDs.contains(ID = ID.replace(' ', '_'))) {
            ID = EventUtils.generateEventKey(ID);
        }
        eventIDs.add(ID);
        ConditionalEvent<T> c = new ConditionalEvent<T>(eventClass, playerClass, spawnCondition, actIDs == null ? new String[]{} : actIDs);
        if (type == EventType.FULL_REPLACE && overrideEvent != null) {
            c.overrideEvent = ID;
            if (!fullReplaceEventList.containsKey(overrideEvent)) {
                fullReplaceEventList.put(overrideEvent, new ArrayList());
            }
            fullReplaceEventList.get(overrideEvent).add(c);
            fullReplaceEvents.put(ID, c);
            eventLogger.info("Full Replacement event " + c + " for event " + overrideEvent + " registered. " + c.getConditions());
            if (bonusCondition != null) {
                normalEventBonusConditions.put(ID, bonusCondition);
                specialEventBonusConditions.put(ID, bonusCondition);
                eventLogger.info("  This event has a bonus condition.");
            }
        } else if (overrideEvent != null) {
            c.overrideEvent = overrideEvent;
            if (!overrideEvents.containsKey(overrideEvent)) {
                overrideEvents.put(overrideEvent, new ArrayList());
            }
            overrideEvents.get(overrideEvent).add(c);
            eventLogger.info("Override event " + c + " for event " + overrideEvent + " registered. " + c.getConditions());
            if (bonusCondition != null) {
                overrideBonusConditions.put(c, bonusCondition);
                eventLogger.info("  This event has a bonus condition.");
            }
        } else if (type == EventType.ONE_TIME) {
            oneTimeEvents.put(ID, c);
            eventLogger.info("SpecialOneTimeEvent " + c + " registered. " + c.getConditions());
            if (bonusCondition != null) {
                specialEventBonusConditions.put(ID, bonusCondition);
                eventLogger.info("  This event has a bonus condition.");
            }
        } else if (type == EventType.SHRINE) {
            shrineEvents.put(ID, c);
            eventLogger.info("Shrine " + c + " registered. " + c.getConditions());
            if (bonusCondition != null) {
                specialEventBonusConditions.put(ID, bonusCondition);
                eventLogger.info("  This event has a bonus condition.");
            }
        } else {
            normalEvents.put(ID, c);
            eventLogger.info("Event " + c + " registered. " + c.getConditions());
            if (bonusCondition != null) {
                normalEventBonusConditions.put(ID, bonusCondition);
                eventLogger.info("  This event has a bonus condition.");
            }
        }
    }

    private static String generateEventKey(String ID) {
        return ID + id++;
    }

    public static AbstractEvent getEvent(String eventID) {
        if (normalEvents.containsKey(eventID)) {
            return normalEvents.get(eventID).getEvent();
        }
        if (shrineEvents.containsKey(eventID)) {
            return shrineEvents.get(eventID).getEvent();
        }
        if (oneTimeEvents.containsKey(eventID)) {
            return oneTimeEvents.get(eventID).getEvent();
        }
        if (fullReplaceEvents.containsKey(eventID)) {
            return fullReplaceEvents.get(eventID).getEvent();
        }
        return null;
    }

    public static Class<? extends AbstractEvent> getEventClass(String eventID) {
        if (normalEvents.containsKey(eventID)) {
            return EventUtils.normalEvents.get((Object)eventID).eventClass;
        }
        if (shrineEvents.containsKey(eventID)) {
            return EventUtils.shrineEvents.get((Object)eventID).eventClass;
        }
        if (oneTimeEvents.containsKey(eventID)) {
            return EventUtils.oneTimeEvents.get((Object)eventID).eventClass;
        }
        if (fullReplaceEvents.containsKey(eventID)) {
            return EventUtils.fullReplaceEvents.get((Object)eventID).eventClass;
        }
        return null;
    }

    public static HashMap<String, Class<? extends AbstractEvent>> getDungeonEvents(String dungeonID) {
        HashMap<String, Class<? extends AbstractEvent>> events = new HashMap<String, Class<? extends AbstractEvent>>();
        for (Map.Entry<String, ConditionalEvent<? extends AbstractEvent>> c : normalEvents.entrySet()) {
            if (!c.getValue().actIDs.contains(dungeonID)) continue;
            events.put(c.getKey(), c.getValue().eventClass);
        }
        for (Map.Entry<String, ConditionalEvent<? extends AbstractEvent>> c : shrineEvents.entrySet()) {
            if (!c.getValue().actIDs.contains(dungeonID)) continue;
            events.put(c.getKey(), c.getValue().eventClass);
        }
        return events;
    }

    public static void loadBaseEvents() {
        try {
            Field eventStrings = LocalizedStrings.class.getDeclaredField("events");
            eventStrings.setAccessible(true);
            Map events = (Map)eventStrings.get(null);
            if (events != null) {
                for (String key : events.keySet()) {
                    eventIDs.add(key.replace(' ', '_'));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static enum EventType {
        NORMAL,
        SHRINE,
        ONE_TIME,
        OVERRIDE,
        FULL_REPLACE;

    }
}

