/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.relic;

import basemod.BaseMod;
import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import basemod.devcommands.relic.Relic;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import java.util.ArrayList;
import java.util.Arrays;

public class RelicFlavor
extends ConsoleCommand {
    public RelicFlavor() {
        this.minExtraTokens = 1;
        this.maxExtraTokens = 1;
        this.simpleCheck = true;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        String[] relicNameArray = Arrays.copyOfRange(tokens, 2, tokens.length);
        String relicName = RelicFlavor.getRelicName(relicNameArray);
        DevConsole.log(RelicLibrary.getRelic((String)relicName).flavorText);
    }

    public static String getRelicName(String[] relicNameArray) {
        String relic = String.join((CharSequence)" ", relicNameArray);
        if (BaseMod.underScoreRelicIDs.containsKey(relic)) {
            relic = BaseMod.underScoreRelicIDs.get(relic);
        }
        return relic;
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        return ConsoleCommand.getRelicOptions();
    }

    @Override
    public void errorMsg() {
        Relic.cmdRelicHelp();
    }
}

