/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.hp;

import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.actions.common.LoseHPAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import java.util.ArrayList;

public class Hp
extends ConsoleCommand {
    public Hp() {
        this.requiresPlayer = true;
        this.minExtraTokens = 2;
        this.maxExtraTokens = 2;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        if (tokens[1].toLowerCase().equals("add") || tokens[1].toLowerCase().equals("a")) {
            try {
                int i = Integer.parseInt(tokens[2]);
                AbstractDungeon.actionManager.addToTop((AbstractGameAction)new HealAction((AbstractCreature)AbstractDungeon.player, (AbstractCreature)AbstractDungeon.player, i));
            }
            catch (Exception e) {
                Hp.cmdHPHelp();
            }
        } else if (tokens[1].toLowerCase().equals("lose") || tokens[1].toLowerCase().equals("l")) {
            try {
                int i = Integer.parseInt(tokens[2]);
                AbstractDungeon.actionManager.addToTop((AbstractGameAction)new LoseHPAction((AbstractCreature)AbstractDungeon.player, (AbstractCreature)AbstractDungeon.player, i, AbstractGameAction.AttackEffect.NONE));
            }
            catch (Exception e) {
                Hp.cmdHPHelp();
            }
        } else {
            Hp.cmdHPHelp();
        }
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("add");
        result.add("lose");
        if (tokens.length == depth + 1) {
            return result;
        }
        if (result.contains(tokens[depth])) {
            if (tokens[depth + 1].matches("\\d+")) {
                complete = true;
            }
            result = Hp.smallNumbers();
        }
        return result;
    }

    @Override
    public void errorMsg() {
        Hp.cmdHPHelp();
    }

    private static void cmdHPHelp() {
        DevConsole.couldNotParse();
        DevConsole.log("options are:");
        DevConsole.log("* add [amt]");
        DevConsole.log("* lose [amt]");
    }
}

