/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.history;

import basemod.DevConsole;
import basemod.ReflectionHacks;
import basemod.devcommands.ConsoleCommand;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.screens.options.DropdownMenu;
import com.megacrit.cardcrawl.screens.runHistory.RunHistoryScreen;
import com.megacrit.cardcrawl.screens.stats.RunData;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class History
extends ConsoleCommand {
    public History() {
        this.requiresPlayer = true;
        this.minExtraTokens = 1;
        this.maxExtraTokens = 1;
        this.simpleCheck = true;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        if (tokens[1].equalsIgnoreCase("random")) {
            History.getrandomVictorySetup();
        } else if (tokens[1].equalsIgnoreCase("last")) {
            History.getlastVictorySetup();
        } else {
            DevConsole.couldNotParse();
        }
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("last");
        result.add("random");
        return result;
    }

    @Override
    public void errorMsg() {
        History.cmdDrawHelp();
    }

    private static void cmdDrawHelp() {
        DevConsole.couldNotParse();
        DevConsole.log("options are:");
        DevConsole.log("* last");
        DevConsole.log("* random");
    }

    public static void getlastVictorySetup() {
        ArrayList<RunData> rdlist = History.getVictories(History.characterIndex(AbstractDungeon.player));
        if (!rdlist.isEmpty()) {
            History.setLoadout(rdlist.get(rdlist.size() - 1));
        } else {
            DevConsole.log("could not find run data for the current class");
        }
    }

    public static void getrandomVictorySetup() {
        ArrayList<RunData> rdlist = History.getVictories(History.characterIndex(AbstractDungeon.player));
        if (!rdlist.isEmpty()) {
            History.setLoadout(rdlist.get(MathUtils.random((int)(rdlist.size() - 1))));
        } else {
            DevConsole.log("could not find run data for the current class");
        }
    }

    public static void setLoadout(RunData rd) {
        AbstractDungeon.player.relics.clear();
        int index = 0;
        for (String relic : rd.relics) {
            AbstractRelic ar = RelicLibrary.getRelic((String)relic);
            ar.instantObtain();
        }
        AbstractDungeon.player.masterDeck.group.clear();
        for (String card : rd.master_deck) {
            AbstractCard ac;
            if (card.matches(".*\\+\\d+")) {
                index = card.lastIndexOf("+");
                ac = CardLibrary.getCopy((String)card.substring(0, index), (int)index, (int)0);
            } else {
                ac = CardLibrary.getCopy((String)card, (int)0, (int)0);
            }
            AbstractDungeon.player.masterDeck.group.add(ac);
        }
        AbstractDungeon.player.currentHealth = AbstractDungeon.player.maxHealth = ((Integer)rd.max_hp_per_floor.get(rd.max_hp_per_floor.size() - 1)).intValue();
    }

    public static ArrayList<RunData> getVictories(int character) {
        ArrayList al = new ArrayList();
        RunHistoryScreen rhs = new RunHistoryScreen();
        rhs.refreshData();
        if (character > 0) {
            ((DropdownMenu)ReflectionHacks.getPrivate(rhs, RunHistoryScreen.class, "characterFilter")).setSelectedIndex(character);
        }
        ((DropdownMenu)ReflectionHacks.getPrivate(rhs, RunHistoryScreen.class, "winLossFilter")).setSelectedIndex(1);
        try {
            Method resetRunsDropdown = RunHistoryScreen.class.getDeclaredMethod("resetRunsDropdown", new Class[0]);
            resetRunsDropdown.setAccessible(true);
            resetRunsDropdown.invoke((Object)rhs, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ArrayList)ReflectionHacks.getPrivate(rhs, RunHistoryScreen.class, "filteredRuns");
    }

    public static int characterIndex(AbstractPlayer p) {
        int index = 1;
        for (AbstractPlayer p2 : CardCrawlGame.characterManager.getAllCharacters()) {
            if (p2.chosenClass == p.chosenClass) break;
            ++index;
        }
        return index;
    }
}

