/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.act;

import basemod.BaseMod;
import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import com.evacipated.cardcrawl.modthespire.Loader;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.screens.DungeonTransitionScreen;
import com.megacrit.cardcrawl.vfx.combat.BattleStartEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ActCommand
extends ConsoleCommand {
    private static Map<String, Integer> acts = new HashMap<String, Integer>();

    public static void initialize() {
        ActCommand.addAct("Exordium", 1);
        ActCommand.addAct("TheCity", 2);
        ActCommand.addAct("TheBeyond", 3);
        ActCommand.addAct("TheEnding", 4);
        if (Loader.isModLoaded((String)"theJungle")) {
            ActCommand.addAct("theJungle:Jungle", 2);
        }
    }

    public static void addAct(String actID, int actNum) {
        if (!(acts.containsKey(actID) || actID.equalsIgnoreCase("boss") || actID.equalsIgnoreCase("num"))) {
            acts.put(actID, actNum);
        } else {
            BaseMod.logger.error("Act " + actID + " is already registered!");
        }
    }

    public ActCommand() {
        this.requiresPlayer = true;
        this.minExtraTokens = 1;
        this.simpleCheck = true;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        if (tokens[depth].equalsIgnoreCase("boss")) {
            DevConsole.log("Skipping to bossroom");
            this.prepareTransition();
            AbstractDungeon.currMapNode.room = new MonsterRoomBoss();
            AbstractDungeon.getCurrRoom().onPlayerEntry();
            AbstractDungeon.rs = AbstractDungeon.RenderScene.NORMAL;
            AbstractDungeon.combatRewardScreen.clear();
            AbstractDungeon.previousScreen = null;
            AbstractDungeon.closeCurrentScreen();
            CardCrawlGame.music.silenceTempBgmInstantly();
            CardCrawlGame.music.silenceBGMInstantly();
        } else if (tokens[depth].equalsIgnoreCase("num")) {
            DevConsole.log("Current Actnumber: " + AbstractDungeon.actNum);
        } else if (acts.containsKey(tokens[depth])) {
            try {
                DevConsole.log("Skipping to act " + tokens[depth]);
                if (AbstractDungeon.floorNum <= 1) {
                    AbstractDungeon.floorNum = 2;
                }
                this.prepareTransition();
                CardCrawlGame.nextDungeon = tokens[depth];
                CardCrawlGame.dungeonTransitionScreen = new DungeonTransitionScreen(tokens[depth]);
                AbstractDungeon.actNum = acts.get(tokens[depth]) - 1;
                AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
            }
            catch (Exception exception) {}
        } else {
            DevConsole.log("Invalid Act ID");
        }
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("boss");
        tmp.add("num");
        for (String s : acts.keySet()) {
            tmp.add(s);
        }
        return tmp;
    }

    private void prepareTransition() {
        AbstractDungeon.player.hand.group.clear();
        AbstractDungeon.actionManager.clear();
        AbstractDungeon.effectsQueue.clear();
        AbstractDungeon.effectList.clear();
        for (int i = AbstractDungeon.topLevelEffects.size() - 1; i > 0; --i) {
            if (!(AbstractDungeon.topLevelEffects.get(i) instanceof BattleStartEffect)) continue;
            AbstractDungeon.topLevelEffects.remove(i);
        }
    }
}

