/*
 * Decompiled with CFR 0.152.
 */
package basemod.animations;

import basemod.animations.AbstractAnimation;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonReader;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;

public class G3DJAnimation
extends AbstractAnimation {
    private String modelString;
    private String animationString;
    private Model myModel;
    private ModelInstance myInstance;
    private AnimationController controller;
    private boolean rescaled = false;

    public G3DJAnimation(String model, String animation) {
        this.modelString = model;
        this.animationString = animation;
        if (this.modelString != null) {
            try {
                JsonReader jsonReader = new JsonReader();
                G3dModelLoader modelLoader = new G3dModelLoader((BaseJsonReader)jsonReader);
                this.myModel = modelLoader.loadModel(Gdx.files.internal(this.modelString));
                for (Material mat : this.myModel.materials) {
                    mat.set((Attribute)new BlendingAttribute(770, 771));
                }
                this.myInstance = new ModelInstance(this.myModel, 0.0f, 0.0f, 10.0f);
                this.myInstance.transform.rotate(1.0f, 0.0f, 0.0f, -90.0f);
                if (this.animationString != null) {
                    this.controller = new AnimationController(this.myInstance);
                    this.controller.setAnimation(this.animationString, 1, new AnimationController.AnimationListener(){

                        public void onEnd(AnimationController.AnimationDesc animation) {
                            G3DJAnimation.this.controller.queue(G3DJAnimation.this.animationString, -1, 1.0f, null, 0.0f);
                        }

                        public void onLoop(AnimationController.AnimationDesc animation) {
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Gdx.app.exit();
            }
        }
    }

    @Override
    public AbstractAnimation.Type type() {
        if (this.modelString != null) {
            return AbstractAnimation.Type.MODEL;
        }
        return AbstractAnimation.Type.NONE;
    }

    @Override
    public void renderModel(ModelBatch batch, Environment env) {
        if (this.animationString != null) {
            this.controller.update(Gdx.graphics.getDeltaTime());
        }
        Vector3 loc = this.myInstance.transform.getTranslation(new Vector3());
        AbstractPlayer player = AbstractDungeon.player;
        if (player != null) {
            loc.x = player.drawX + player.animX - (float)(Gdx.graphics.getWidth() / 2);
            loc.y = player.drawY + player.animY + AbstractDungeon.sceneOffsetY - (float)(Gdx.graphics.getHeight() / 2);
            this.myInstance.transform.setTranslation(loc);
            if (!this.rescaled) {
                this.myInstance.transform.scale(Settings.scale, 1.0f, Settings.scale);
                this.rescaled = true;
            }
            batch.render((RenderableProvider)this.myInstance, env);
        }
    }
}

