/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts.cardbuilder.actionbuilder;

import basemod.abstracts.cardbuilder.CardBasic;
import basemod.abstracts.cardbuilder.actionbuilder.ActionBuilder;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class AllEnemyActionBuilder
extends ActionBuilder {
    private ActionBuilder singleAction;

    public AllEnemyActionBuilder(ActionBuilder singleAction) {
        this.singleAction = singleAction;
    }

    @Override
    public String description(CardBasic card) {
        String singleActionDescription = this.singleAction.description(card);
        return singleActionDescription.substring(0, singleActionDescription.length()).concat(" to all enemies.");
    }

    @Override
    public AbstractGameAction buildAction(final CardBasic card, final AbstractPlayer player, final AbstractMonster monster) {
        return new AbstractGameAction(){

            public void update() {
                if (!AbstractDungeon.getMonsters().areMonstersBasicallyDead()) {
                    for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                        if (m.isDead || m.isDying) continue;
                        if (AllEnemyActionBuilder.this.singleAction.toTop()) {
                            AbstractDungeon.actionManager.addToTop(AllEnemyActionBuilder.this.singleAction.buildAction(card, player, monster));
                            continue;
                        }
                        AbstractDungeon.actionManager.addToBottom(AllEnemyActionBuilder.this.singleAction.buildAction(card, player, monster));
                    }
                }
            }
        };
    }
}

