/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts;

import basemod.BaseMod;
import basemod.ReflectionHacks;
import basemod.helpers.BaseModCardTags;
import basemod.helpers.TooltipInfo;
import basemod.patches.com.megacrit.cardcrawl.screens.SingleCardViewPopup.TitleFontSize;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.evacipated.cardcrawl.modthespire.lib.SpireOverride;
import com.evacipated.cardcrawl.modthespire.lib.SpireSuper;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CustomCard
extends AbstractCard {
    public static HashMap<String, Texture> imgMap = new HashMap();
    public static final String PORTRAIT_ENDING = "_p";
    public String textureImg;
    public String textureOrbSmallImg = null;
    public String textureOrbLargeImg = null;
    public String textureBackgroundSmallImg = null;
    public String textureBackgroundLargeImg = null;
    public String textureBannerSmallImg = null;
    public String textureBannerLargeImg = null;
    public TextureAtlas.AtlasRegion bannerSmallRegion = null;
    public TextureAtlas.AtlasRegion bannerLargeRegion = null;
    public TextureAtlas.AtlasRegion frameSmallRegion = null;
    public TextureAtlas.AtlasRegion frameLargeRegion = null;
    public TextureAtlas.AtlasRegion frameMiddleRegion = null;
    public TextureAtlas.AtlasRegion frameLeftRegion = null;
    public TextureAtlas.AtlasRegion frameRightRegion = null;
    public TextureAtlas.AtlasRegion frameMiddleLargeRegion = null;
    public TextureAtlas.AtlasRegion frameLeftLargeRegion = null;
    public TextureAtlas.AtlasRegion frameRightLargeRegion = null;
    private static Map<Class<? extends CustomCard>, BitmapFont> titleFontMap = new HashMap<Class<? extends CustomCard>, BitmapFont>();

    public static Texture getPortraitImage(CustomCard card) {
        return card.getPortraitImage();
    }

    private static void loadTextureFromString(String textureString) {
        if (!imgMap.containsKey(textureString)) {
            imgMap.put(textureString, ImageMaster.loadImage((String)textureString));
        }
    }

    private static Texture getTextureFromString(String textureString) {
        CustomCard.loadTextureFromString(textureString);
        return imgMap.get(textureString);
    }

    public AbstractCard makeCopy() {
        try {
            return (AbstractCard)((Object)((Object)this)).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("BaseMod failed to auto-generate makeCopy for card: " + this.cardID);
        }
    }

    public CustomCard(String id, String name, String img, int cost, String rawDescription, AbstractCard.CardType type, AbstractCard.CardColor color, AbstractCard.CardRarity rarity, AbstractCard.CardTarget target) {
        super(id, name, "status/beta", "status/beta", cost, rawDescription, type, color, rarity, target);
        this.textureImg = img;
        if (img != null) {
            this.loadCardImage(img);
        }
    }

    public CustomCard(String id, String name, RegionName img, int cost, String rawDescription, AbstractCard.CardType type, AbstractCard.CardColor color, AbstractCard.CardRarity rarity, AbstractCard.CardTarget target) {
        super(id, name, "status/beta", img.name, cost, rawDescription, type, color, rarity, target);
    }

    public Texture getOrbSmallTexture() {
        if (this.textureOrbSmallImg == null) {
            return BaseMod.getEnergyOrbTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureOrbSmallImg);
    }

    public Texture getOrbLargeTexture() {
        if (this.textureOrbLargeImg == null) {
            return BaseMod.getEnergyOrbPortraitTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureOrbLargeImg);
    }

    public void setOrbTexture(String orbSmallImg, String orbLargeImg) {
        this.textureOrbSmallImg = orbSmallImg;
        this.textureOrbLargeImg = orbLargeImg;
        CustomCard.loadTextureFromString(orbSmallImg);
        CustomCard.loadTextureFromString(orbLargeImg);
    }

    public Texture getBackgroundSmallTexture() {
        if (this.textureBackgroundSmallImg == null) {
            switch (this.type) {
                case ATTACK: {
                    return BaseMod.getAttackBgTexture(this.color);
                }
                case POWER: {
                    return BaseMod.getPowerBgTexture(this.color);
                }
            }
            return BaseMod.getSkillBgTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureBackgroundSmallImg);
    }

    public Texture getBackgroundLargeTexture() {
        if (this.textureBackgroundLargeImg == null) {
            switch (this.type) {
                case ATTACK: {
                    return BaseMod.getAttackBgPortraitTexture(this.color);
                }
                case POWER: {
                    return BaseMod.getPowerBgPortraitTexture(this.color);
                }
            }
            return BaseMod.getSkillBgPortraitTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureBackgroundLargeImg);
    }

    public void setBackgroundTexture(String backgroundSmallImg, String backgroundLargeImg) {
        this.textureBackgroundSmallImg = backgroundSmallImg;
        this.textureBackgroundLargeImg = backgroundLargeImg;
        CustomCard.loadTextureFromString(backgroundSmallImg);
        CustomCard.loadTextureFromString(backgroundLargeImg);
    }

    public Texture getBannerSmallTexture() {
        if (this.textureBannerSmallImg == null) {
            return null;
        }
        return CustomCard.getTextureFromString(this.textureBannerSmallImg);
    }

    public Texture getBannerLargeTexture() {
        if (this.textureBannerLargeImg == null) {
            return null;
        }
        return CustomCard.getTextureFromString(this.textureBannerLargeImg);
    }

    public TextureAtlas.AtlasRegion getBannerSmallRegion() {
        if (this.bannerSmallRegion == null && this.textureBannerSmallImg != null) {
            Texture t = this.getBannerSmallTexture();
            this.bannerSmallRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        }
        return this.bannerSmallRegion;
    }

    public TextureAtlas.AtlasRegion getBannerLargeRegion() {
        if (this.bannerLargeRegion == null && this.textureBannerLargeImg != null) {
            Texture t = this.getBannerLargeTexture();
            this.bannerLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        }
        return this.bannerLargeRegion;
    }

    public void setBannerTexture(String bannerSmallImg, String bannerLargeImg) {
        this.textureBannerSmallImg = bannerSmallImg;
        this.textureBannerLargeImg = bannerLargeImg;
        CustomCard.loadTextureFromString(bannerSmallImg);
        CustomCard.loadTextureFromString(bannerLargeImg);
        Texture t = this.getBannerSmallTexture();
        this.bannerSmallRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = this.getBannerLargeTexture();
        this.bannerLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
    }

    public void setPortraitTextures(String cardFrameSmall, String cardFrameLarge) {
        CustomCard.loadTextureFromString(cardFrameSmall);
        CustomCard.loadTextureFromString(cardFrameLarge);
        Texture t = CustomCard.getTextureFromString(cardFrameSmall);
        this.frameSmallRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(cardFrameLarge);
        this.frameLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
    }

    public void setPortraitTextures(String cardFrameSmall, String cardFrameLarge, String dynamicLeftFrame, String dynamicMiddleFrame, String dynamicRightFrame, String dynamicLeftFrameLarge, String dynamicMiddleFrameLarge, String dynamicRightFrameLarge) {
        CustomCard.loadTextureFromString(cardFrameSmall);
        CustomCard.loadTextureFromString(cardFrameLarge);
        CustomCard.loadTextureFromString(dynamicLeftFrame);
        CustomCard.loadTextureFromString(dynamicMiddleFrame);
        CustomCard.loadTextureFromString(dynamicRightFrame);
        CustomCard.loadTextureFromString(dynamicLeftFrameLarge);
        CustomCard.loadTextureFromString(dynamicMiddleFrameLarge);
        CustomCard.loadTextureFromString(dynamicRightFrameLarge);
        Texture t = CustomCard.getTextureFromString(cardFrameSmall);
        this.frameSmallRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(cardFrameLarge);
        this.frameLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(dynamicLeftFrame);
        this.frameLeftRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(dynamicMiddleFrame);
        this.frameMiddleRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(dynamicRightFrame);
        this.frameRightRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(dynamicLeftFrameLarge);
        this.frameLeftLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(dynamicMiddleFrameLarge);
        this.frameMiddleLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
        t = CustomCard.getTextureFromString(dynamicRightFrameLarge);
        this.frameRightLargeRegion = new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
    }

    public void setDisplayRarity(AbstractCard.CardRarity rarity) {
        switch (rarity) {
            case BASIC: 
            case CURSE: 
            case SPECIAL: 
            case COMMON: {
                this.bannerSmallRegion = ImageMaster.CARD_BANNER_COMMON;
                this.bannerLargeRegion = ImageMaster.CARD_BANNER_COMMON_L;
                switch (this.type) {
                    case ATTACK: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_ATTACK_COMMON;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_ATTACK_COMMON_L;
                        break;
                    }
                    case POWER: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_POWER_COMMON;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_POWER_COMMON_L;
                        break;
                    }
                    default: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_SKILL_COMMON;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_SKILL_COMMON_L;
                    }
                }
                this.frameMiddleRegion = ImageMaster.CARD_COMMON_FRAME_MID;
                this.frameLeftRegion = ImageMaster.CARD_COMMON_FRAME_LEFT;
                this.frameRightRegion = ImageMaster.CARD_COMMON_FRAME_RIGHT;
                this.frameMiddleLargeRegion = ImageMaster.CARD_COMMON_FRAME_MID_L;
                this.frameLeftLargeRegion = ImageMaster.CARD_COMMON_FRAME_LEFT_L;
                this.frameRightLargeRegion = ImageMaster.CARD_COMMON_FRAME_RIGHT_L;
                break;
            }
            case UNCOMMON: {
                this.bannerSmallRegion = ImageMaster.CARD_BANNER_UNCOMMON;
                this.bannerLargeRegion = ImageMaster.CARD_BANNER_UNCOMMON_L;
                switch (this.type) {
                    case ATTACK: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_ATTACK_UNCOMMON;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_ATTACK_UNCOMMON_L;
                        break;
                    }
                    case POWER: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_POWER_UNCOMMON;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_POWER_UNCOMMON_L;
                        break;
                    }
                    default: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_SKILL_UNCOMMON;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_SKILL_UNCOMMON_L;
                    }
                }
                this.frameMiddleRegion = ImageMaster.CARD_UNCOMMON_FRAME_MID;
                this.frameLeftRegion = ImageMaster.CARD_UNCOMMON_FRAME_LEFT;
                this.frameRightRegion = ImageMaster.CARD_UNCOMMON_FRAME_RIGHT;
                this.frameMiddleLargeRegion = ImageMaster.CARD_UNCOMMON_FRAME_MID_L;
                this.frameLeftLargeRegion = ImageMaster.CARD_UNCOMMON_FRAME_LEFT_L;
                this.frameRightLargeRegion = ImageMaster.CARD_UNCOMMON_FRAME_RIGHT_L;
                break;
            }
            case RARE: {
                this.bannerSmallRegion = ImageMaster.CARD_BANNER_RARE;
                this.bannerLargeRegion = ImageMaster.CARD_BANNER_RARE_L;
                switch (this.type) {
                    case ATTACK: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_ATTACK_RARE;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_ATTACK_RARE_L;
                        break;
                    }
                    case POWER: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_POWER_RARE;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_POWER_RARE_L;
                        break;
                    }
                    default: {
                        this.frameSmallRegion = ImageMaster.CARD_FRAME_SKILL_RARE;
                        this.frameLargeRegion = ImageMaster.CARD_FRAME_SKILL_RARE_L;
                    }
                }
                this.frameMiddleRegion = ImageMaster.CARD_RARE_FRAME_MID;
                this.frameLeftRegion = ImageMaster.CARD_RARE_FRAME_LEFT;
                this.frameRightRegion = ImageMaster.CARD_RARE_FRAME_RIGHT;
                this.frameMiddleLargeRegion = ImageMaster.CARD_RARE_FRAME_MID_L;
                this.frameLeftLargeRegion = ImageMaster.CARD_RARE_FRAME_LEFT_L;
                this.frameRightLargeRegion = ImageMaster.CARD_RARE_FRAME_RIGHT_L;
                break;
            }
            default: {
                System.out.println("Attempted to set display rarity to an unknown rarity: " + rarity.name());
            }
        }
    }

    public float calculateModifiedCardDamage(AbstractPlayer player, AbstractMonster mo, float tmp) {
        return tmp;
    }

    public float calculateModifiedCardDamage(AbstractPlayer player, float tmp) {
        return this.calculateModifiedCardDamage(player, null, tmp);
    }

    public void loadCardImage(String img) {
        Texture cardTexture;
        if (imgMap.containsKey(img)) {
            cardTexture = imgMap.get(img);
        } else {
            cardTexture = ImageMaster.loadImage((String)img);
            imgMap.put(img, cardTexture);
        }
        cardTexture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        int tw = cardTexture.getWidth();
        int th = cardTexture.getHeight();
        TextureAtlas.AtlasRegion cardImg = new TextureAtlas.AtlasRegion(cardTexture, 0, 0, tw, th);
        ReflectionHacks.setPrivateInherited((Object)this, CustomCard.class, "portrait", cardImg);
    }

    public List<TooltipInfo> getCustomTooltips() {
        return null;
    }

    public List<TooltipInfo> getCustomTooltipsTop() {
        return null;
    }

    @Deprecated
    public boolean isStrike() {
        return this.hasTag(BaseModCardTags.BASIC_STRIKE);
    }

    @Deprecated
    public boolean isDefend() {
        return this.hasTag(BaseModCardTags.BASIC_DEFEND);
    }

    public void unlock() {
        this.isLocked = false;
    }

    public float getTitleFontSize() {
        return -1.0f;
    }

    private BitmapFont getTitleFont() {
        if (this.getTitleFontSize() < 0.0f) {
            return null;
        }
        BitmapFont font = titleFontMap.get(((Object)((Object)this)).getClass());
        if (font == null) {
            font = CustomCard.generateTitleFont(this.getTitleFontSize());
            titleFontMap.put(((Object)((Object)this)).getClass(), font);
        }
        return font;
    }

    @SpireOverride
    protected void renderTitle(SpriteBatch sb) {
        BitmapFont titleFont = this.getTitleFont();
        if (titleFont == null) {
            SpireSuper.call((Object[])new Object[]{sb});
            return;
        }
        BitmapFont savedFont = FontHelper.cardTitleFont;
        FontHelper.cardTitleFont = titleFont;
        Boolean useSmallTitleFont = (Boolean)ReflectionHacks.getPrivate((Object)this, AbstractCard.class, "useSmallTitleFont");
        ReflectionHacks.setPrivate((Object)this, AbstractCard.class, "useSmallTitleFont", false);
        SpireSuper.call((Object[])new Object[]{sb});
        ReflectionHacks.setPrivate((Object)this, AbstractCard.class, "useSmallTitleFont", useSmallTitleFont);
        FontHelper.cardTitleFont = savedFont;
    }

    private static BitmapFont generateTitleFont(float size) {
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        param.minFilter = Texture.TextureFilter.Linear;
        param.magFilter = Texture.TextureFilter.Linear;
        param.hinting = FreeTypeFontGenerator.Hinting.Slight;
        param.spaceX = 0;
        param.kerning = true;
        param.borderColor = new Color(0.35f, 0.35f, 0.35f, 1.0f);
        param.borderWidth = 2.25f * Settings.scale;
        param.gamma = 0.9f;
        param.borderGamma = 0.9f;
        param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        param.shadowOffsetX = Math.round(3.0f * Settings.scale);
        param.shadowOffsetY = Math.round(3.0f * Settings.scale);
        param.borderStraight = false;
        param.characters = "";
        param.incremental = true;
        param.size = Math.round(size * Settings.scale);
        FreeTypeFontGenerator g = new FreeTypeFontGenerator(TitleFontSize.fontFile);
        g.scaleForPixelHeight(param.size);
        BitmapFont font = g.generateFont(param);
        font.setUseIntegerPositions(false);
        font.getData().markupEnabled = true;
        if (LocalizedStrings.break_chars != null) {
            font.getData().breakChars = LocalizedStrings.break_chars.toCharArray();
        }
        return font;
    }

    public List<String> getCardDescriptors() {
        return Collections.emptyList();
    }

    protected Texture getPortraitImage() {
        Texture portraitTexture;
        if (this.textureImg == null) {
            return null;
        }
        int endingIndex = this.textureImg.lastIndexOf(".");
        String newPath = this.textureImg.substring(0, endingIndex) + PORTRAIT_ENDING + this.textureImg.substring(endingIndex);
        System.out.println("Finding texture: " + newPath);
        try {
            portraitTexture = ImageMaster.loadImage((String)newPath);
        }
        catch (Exception e) {
            portraitTexture = null;
        }
        return portraitTexture;
    }

    public static class RegionName {
        public final String name;

        public RegionName(String name) {
            this.name = name;
        }
    }
}

