/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class AbstractCardModifier
implements Comparable<AbstractCardModifier> {
    public int priority = 0;

    public boolean removeOnCardPlayed(AbstractCard card) {
        return false;
    }

    public boolean removeAtEndOfTurn(AbstractCard card) {
        return false;
    }

    public boolean isInherent(AbstractCard card) {
        return false;
    }

    public float modifyDamage(float damage, DamageInfo.DamageType type, AbstractCard card, AbstractMonster target) {
        return damage;
    }

    public float modifyDamageFinal(float damage, DamageInfo.DamageType type, AbstractCard card, AbstractMonster target) {
        return damage;
    }

    public float modifyBlock(float block, AbstractCard card) {
        return block;
    }

    public float modifyBlockFinal(float block, AbstractCard card) {
        return block;
    }

    public String modifyDescription(String rawDescription, AbstractCard card) {
        return rawDescription;
    }

    public void onUse(AbstractCard card, AbstractCreature target, UseCardAction action) {
    }

    public void onDrawn(AbstractCard card) {
    }

    public void onExhausted(AbstractCard card) {
    }

    public void onInitialApplication(AbstractCard card) {
    }

    public void onRemove(AbstractCard card) {
    }

    public void onApplyPowers(AbstractCard card) {
    }

    public void onCalculateCardDamage(AbstractCard card, AbstractMonster mo) {
    }

    public void onUpdate(AbstractCard card) {
    }

    public void onRender(AbstractCard card, SpriteBatch sb) {
    }

    public void atEndOfTurn(AbstractCard card, CardGroup group) {
    }

    public void onOtherCardPlayed(AbstractCard card, AbstractCard otherCard, CardGroup group) {
    }

    public boolean canPlayCard(AbstractCard card) {
        return true;
    }

    public void onRetained(AbstractCard card) {
    }

    public abstract AbstractCardModifier makeCopy();

    public String identifier(AbstractCard card) {
        return "";
    }

    public boolean shouldApply(AbstractCard card) {
        return true;
    }

    @Override
    public int compareTo(AbstractCardModifier other) {
        return this.priority - other.priority;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SaveIgnore {
    }
}

